/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface ClusterMetrics {
    @Nullable
    public String getHBaseVersion();

    public List<ServerName> getDeadServerNames();

    public Map<ServerName, ServerMetrics> getLiveServerMetrics();

    default public int getRegionCount() {
        return this.getLiveServerMetrics().entrySet().stream().mapToInt(v -> ((ServerMetrics)v.getValue()).getRegionMetrics().size()).sum();
    }

    default public long getRequestCount() {
        return this.getLiveServerMetrics().entrySet().stream().flatMap(v -> ((ServerMetrics)v.getValue()).getRegionMetrics().values().stream()).mapToLong(RegionMetrics::getRequestCount).sum();
    }

    @Nullable
    public ServerName getMasterName();

    public List<ServerName> getBackupMasterNames();

    @InterfaceAudience.Private
    public List<RegionState> getRegionStatesInTransition();

    @Nullable
    public String getClusterId();

    public List<String> getMasterCoprocessorNames();

    default public long getLastMajorCompactionTimestamp(TableName table) {
        return this.getLiveServerMetrics().values().stream().flatMap(s -> s.getRegionMetrics().values().stream()).filter(r -> RegionInfo.getTable(r.getRegionName()).equals(table)).mapToLong(RegionMetrics::getLastMajorCompactionTimestamp).min().orElse(0L);
    }

    default public long getLastMajorCompactionTimestamp(byte[] regionName) {
        return this.getLiveServerMetrics().values().stream().filter(s -> s.getRegionMetrics().containsKey(regionName)).findAny().map(s -> s.getRegionMetrics().get(regionName).getLastMajorCompactionTimestamp()).orElse(0L);
    }

    @Nullable
    public Boolean getBalancerOn();

    public int getMasterInfoPort();

    public List<ServerName> getServersName();

    default public double getAverageLoad() {
        int serverSize = this.getLiveServerMetrics().size();
        if (serverSize == 0) {
            return 0.0;
        }
        return (double)this.getRegionCount() / (double)serverSize;
    }

    public Map<TableName, RegionStatesCount> getTableRegionStatesCount();

    public static enum Option {
        HBASE_VERSION,
        CLUSTER_ID,
        BALANCER_ON,
        LIVE_SERVERS,
        DEAD_SERVERS,
        MASTER,
        BACKUP_MASTERS,
        MASTER_COPROCESSORS,
        REGIONS_IN_TRANSITION,
        MASTER_INFO_PORT,
        SERVERS_NAME,
        TABLE_TO_REGIONS_COUNT;

    }
}

