/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionCoprocessorServiceExec
implements Row {
    private final byte[] region;
    private final byte[] startKey;
    private final Descriptors.MethodDescriptor method;
    private final Message request;

    public RegionCoprocessorServiceExec(byte[] region, byte[] startKey, Descriptors.MethodDescriptor method, Message request) {
        this.region = region;
        this.startKey = startKey;
        this.method = method;
        this.request = request;
    }

    @Override
    public byte[] getRow() {
        return this.startKey;
    }

    public byte[] getRegion() {
        return this.region;
    }

    public Descriptors.MethodDescriptor getMethod() {
        return this.method;
    }

    public Message getRequest() {
        return this.request;
    }

    @Override
    public int compareTo(Row o) {
        int res = Bytes.compareTo(this.getRow(), o.getRow());
        if (o instanceof RegionCoprocessorServiceExec && res == 0) {
            RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)o;
            res = this.method.getFullName().compareTo(exec.getMethod().getFullName());
            if (res == 0) {
                res = Bytes.compareTo(this.request.toByteArray(), exec.getRequest().toByteArray());
            }
        }
        return res;
    }

    public int hashCode() {
        return Objects.hashCode(Bytes.hashCode(this.getRow()), this.method.getFullName(), this.request);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((RegionCoprocessorServiceExec)obj) == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("region:").append(Bytes.toStringBinary(this.region)).append(", startKey:").append(Bytes.toStringBinary(this.startKey)).append(", method:").append(this.method.getFullName()).append(", request:").append(this.request);
        return builder.toString();
    }
}

