/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReplicationPeerConfigUpgrader {
    private static final String TABLE_CFS_ZNODE = "zookeeper.znode.replication.peers.tableCFs";
    private static final String TABLE_CFS_ZNODE_DEFAULT = "tableCFs";
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationPeerConfigUpgrader.class);
    private final Configuration conf;
    private final ZKWatcher zookeeper;
    private final ReplicationPeerStorage peerStorage;

    public ReplicationPeerConfigUpgrader(ZKWatcher zookeeper, Configuration conf) throws IOException {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.peerStorage = ReplicationStorageFactory.getReplicationPeerStorage((FileSystem)FileSystem.get((Configuration)conf), (ZKWatcher)zookeeper, (Configuration)conf);
    }

    public void upgrade() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);){
            Admin admin = conn.getAdmin();
            admin.listReplicationPeers().forEach(peerDesc -> {
                String peerId = peerDesc.getPeerId();
                ReplicationPeerConfig peerConfig = peerDesc.getPeerConfig();
                if (peerConfig.getNamespaces() != null && !peerConfig.getNamespaces().isEmpty() || peerConfig.getTableCFsMap() != null && !peerConfig.getTableCFsMap().isEmpty()) {
                    peerConfig.setReplicateAllUserTables(false);
                    try {
                        admin.updateReplicationPeerConfig(peerId, peerConfig);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to upgrade replication peer config for peerId=" + peerId, (Throwable)e);
                    }
                }
            });
        }
    }

    public void copyTableCFs() throws ReplicationException {
        for (String peerId : this.peerStorage.listPeerIds()) {
            if (this.copyTableCFs(peerId)) continue;
            LOG.error("upgrade tableCFs failed for peerId=" + peerId);
        }
    }

    protected String getTableCFsNode(String peerId) {
        String replicationZNode = ZNodePaths.joinZNode((String)this.zookeeper.getZNodePaths().baseZNode, (String)this.conf.get("zookeeper.znode.replication", "replication"));
        String peersZNode = ZNodePaths.joinZNode((String)replicationZNode, (String)this.conf.get("zookeeper.znode.replication.peers", "peers"));
        return ZNodePaths.joinZNode((String)peersZNode, (String)ZNodePaths.joinZNode((String)peerId, (String)this.conf.get(TABLE_CFS_ZNODE, TABLE_CFS_ZNODE_DEFAULT)));
    }

    public boolean copyTableCFs(String peerId) throws ReplicationException {
        String tableCFsNode = this.getTableCFsNode(peerId);
        try {
            if (ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)tableCFsNode) != -1) {
                ReplicationPeerConfig rpc = this.peerStorage.getPeerConfig(peerId);
                if (rpc.getTableCFsMap() == null || rpc.getTableCFsMap().isEmpty()) {
                    LOG.info("Copy table ColumnFamilies into peer=" + peerId);
                    ReplicationProtos.TableCF[] tableCFs = ReplicationPeerConfigUtil.parseTableCFs((byte[])ZKUtil.getData((ZKWatcher)this.zookeeper, (String)tableCFsNode));
                    if (tableCFs != null && tableCFs.length > 0) {
                        rpc.setTableCFsMap(ReplicationPeerConfigUtil.convert2Map((ReplicationProtos.TableCF[])tableCFs));
                        this.peerStorage.updatePeerConfig(peerId, rpc);
                    }
                } else {
                    LOG.info("No tableCFs in peerNode:" + peerId);
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        return true;
    }

    private static void printUsageAndExit() {
        System.err.printf("Usage: hbase org.apache.hadoop.hbase.replication.master.ReplicationPeerConfigUpgrader [options]", new Object[0]);
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help      Show this help and exit.");
        System.err.println("  copyTableCFs  Copy table-cfs to replication peer config");
        System.err.println("  upgrade           Upgrade replication peer config to new format");
        System.err.println();
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        }
        if (args[0].equals("-help") || args[0].equals("-h")) {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        } else if (args[0].equals("copyTableCFs")) {
            Configuration conf = HBaseConfiguration.create();
            try (ZKWatcher zkw = new ZKWatcher(conf, "ReplicationPeerConfigUpgrader", null);){
                ReplicationPeerConfigUpgrader tableCFsUpdater = new ReplicationPeerConfigUpgrader(zkw, conf);
                tableCFsUpdater.copyTableCFs();
            }
        } else if (args[0].equals("upgrade")) {
            Configuration conf = HBaseConfiguration.create();
            try (ZKWatcher zkw = new ZKWatcher(conf, "ReplicationPeerConfigUpgrader", null);){
                ReplicationPeerConfigUpgrader upgrader = new ReplicationPeerConfigUpgrader(zkw, conf);
                upgrader.upgrade();
            }
        } else {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        }
    }
}

