/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private final MetricsWALSource metricsWALSource;
    private final ByteBuffAllocator allocator;
    private BlockCache blockCache;
    private BlockCache l1Cache = null;
    private BlockCache l2Cache = null;
    private MobFileCache mobFileCache;
    private CacheStats cacheStats;
    private CacheStats l1Stats = null;
    private CacheStats l2Stats = null;
    private volatile long numWALFiles = 0L;
    private volatile long walFileSize = 0L;
    private volatile long mobFileCacheAccessCount = 0L;
    private volatile long mobFileCacheMissCount = 0L;
    private volatile double mobFileCacheHitRatio = 0.0;
    private volatile long mobFileCacheEvictedCount = 0L;
    private volatile long mobFileCacheCount = 0L;
    private volatile RegionMetricAggregate aggregate = new RegionMetricAggregate(null);
    protected final Map<String, ArrayList<Long>> requestsCountCache = new ConcurrentHashMap<String, ArrayList<Long>>();
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private DFSHedgedReadMetrics dfsHedgedReadMetrics;
    private final ExcludeDatanodeManager excludeDatanodeManager;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.initMobFileCache();
        this.excludeDatanodeManager = this.regionServer.getWalFactory().getExcludeDatanodeManager();
        this.period = regionServer.getConfiguration().getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        this.metricsWALSource = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        this.allocator = regionServer.getRpcServer().getByteBuffAllocator();
        try {
            this.dfsHedgedReadMetrics = FSUtils.getDFSHedgedReadMetrics(regionServer.getConfiguration());
        }
        catch (IOException e) {
            LOG.warn("Failed to get hedged metrics", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Computing regionserver metrics every " + this.period + " milliseconds");
        }
    }

    private void initBlockCache() {
        this.blockCache = this.regionServer.getBlockCache().orElse(null);
        CacheStats cacheStats = this.cacheStats = this.blockCache != null ? this.blockCache.getStats() : null;
        if (this.cacheStats != null) {
            if (this.cacheStats instanceof CombinedBlockCache.CombinedCacheStats) {
                this.l1Stats = ((CombinedBlockCache.CombinedCacheStats)this.cacheStats).getLruCacheStats();
                this.l2Stats = ((CombinedBlockCache.CombinedCacheStats)this.cacheStats).getBucketCacheStats();
            } else {
                this.l1Stats = this.cacheStats;
            }
        }
        if (this.blockCache != null) {
            if (this.blockCache instanceof CombinedBlockCache) {
                this.l1Cache = ((CombinedBlockCache)this.blockCache).getFirstLevelCache();
                this.l2Cache = ((CombinedBlockCache)this.blockCache).getSecondLevelCache();
            } else {
                this.l1Cache = this.blockCache;
            }
        }
    }

    private void initMobFileCache() {
        this.mobFileCache = this.regionServer.getMobFileCache().orElse(null);
    }

    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    public String getZookeeperQuorum() {
        ZKWatcher zk = this.regionServer.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getRegionServerCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])coprocessors, (String)", ");
    }

    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public long getNumOnlineRegions() {
        Collection<HRegion> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    public long getTotalRequestCount() {
        return this.regionServer.rpcServices.requestCount.sum();
    }

    public long getTotalRowActionRequestCount() {
        return this.aggregate.readRequestsCount + this.aggregate.writeRequestsCount;
    }

    public int getSplitQueueSize() {
        CompactSplit compactSplit = this.regionServer.getCompactSplitThread();
        return compactSplit == null ? 0 : compactSplit.getSplitQueueSize();
    }

    public int getCompactionQueueSize() {
        CompactSplit compactSplit = this.regionServer.getCompactSplitThread();
        return compactSplit == null ? 0 : compactSplit.getCompactionQueueSize();
    }

    public int getSmallCompactionQueueSize() {
        CompactSplit compactSplit = this.regionServer.getCompactSplitThread();
        return compactSplit == null ? 0 : compactSplit.getSmallCompactionQueueSize();
    }

    public int getLargeCompactionQueueSize() {
        CompactSplit compactSplit = this.regionServer.getCompactSplitThread();
        return compactSplit == null ? 0 : compactSplit.getLargeCompactionQueueSize();
    }

    public int getFlushQueueSize() {
        if (this.regionServer.getMemStoreFlusher() == null) {
            return 0;
        }
        return this.regionServer.getMemStoreFlusher().getFlushQueueSize();
    }

    public long getBlockCacheCount() {
        return this.blockCache != null ? this.blockCache.getBlockCount() : 0L;
    }

    public long getBlockCacheDataBlockCount() {
        return this.blockCache != null ? this.blockCache.getDataBlockCount() : 0L;
    }

    public long getMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalMemStoreLimit();
    }

    public long getOnHeapMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalOnHeapMemStoreLimit();
    }

    public long getOffHeapMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalOffHeapMemStoreLimit();
    }

    public long getBlockCacheSize() {
        return this.blockCache != null ? this.blockCache.getCurrentSize() : 0L;
    }

    public long getBlockCacheFreeSize() {
        return this.blockCache != null ? this.blockCache.getFreeSize() : 0L;
    }

    public long getBlockCacheHitCount() {
        return this.cacheStats != null ? this.cacheStats.getHitCount() : 0L;
    }

    public long getBlockCachePrimaryHitCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryHitCount() : 0L;
    }

    public long getBlockCacheHitCachingCount() {
        return this.cacheStats != null ? this.cacheStats.getHitCachingCount() : 0L;
    }

    public long getBlockCacheMissCount() {
        return this.cacheStats != null ? this.cacheStats.getMissCount() : 0L;
    }

    public long getBlockCachePrimaryMissCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryMissCount() : 0L;
    }

    public long getBlockCacheMissCachingCount() {
        return this.cacheStats != null ? this.cacheStats.getMissCachingCount() : 0L;
    }

    public long getBlockCacheEvictedCount() {
        return this.cacheStats != null ? this.cacheStats.getEvictedCount() : 0L;
    }

    public long getBlockCachePrimaryEvictedCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryEvictedCount() : 0L;
    }

    public double getBlockCacheHitPercent() {
        double ratio;
        double d = ratio = this.cacheStats != null ? this.cacheStats.getHitRatio() : 0.0;
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    public double getBlockCacheHitCachingPercent() {
        double ratio;
        double d = ratio = this.cacheStats != null ? this.cacheStats.getHitCachingRatio() : 0.0;
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    public long getBlockCacheFailedInsertions() {
        return this.cacheStats != null ? this.cacheStats.getFailedInserts() : 0L;
    }

    public long getL1CacheSize() {
        return this.l1Cache != null ? this.l1Cache.getCurrentSize() : 0L;
    }

    public long getL1CacheFreeSize() {
        return this.l1Cache != null ? this.l1Cache.getFreeSize() : 0L;
    }

    public long getL1CacheCount() {
        return this.l1Cache != null ? this.l1Cache.getBlockCount() : 0L;
    }

    public long getL1CacheEvictedCount() {
        return this.l1Stats != null ? this.l1Stats.getEvictedCount() : 0L;
    }

    public long getL2CacheSize() {
        return this.l2Cache != null ? this.l2Cache.getCurrentSize() : 0L;
    }

    public long getL2CacheFreeSize() {
        return this.l2Cache != null ? this.l2Cache.getFreeSize() : 0L;
    }

    public long getL2CacheCount() {
        return this.l2Cache != null ? this.l2Cache.getBlockCount() : 0L;
    }

    public long getL2CacheEvictedCount() {
        return this.l2Stats != null ? this.l2Stats.getEvictedCount() : 0L;
    }

    public long getL1CacheHitCount() {
        return this.l1Stats != null ? this.l1Stats.getHitCount() : 0L;
    }

    public long getL1CacheMissCount() {
        return this.l1Stats != null ? this.l1Stats.getMissCount() : 0L;
    }

    public double getL1CacheHitRatio() {
        return this.l1Stats != null ? this.l1Stats.getHitRatio() : 0.0;
    }

    public double getL1CacheMissRatio() {
        return this.l1Stats != null ? this.l1Stats.getMissRatio() : 0.0;
    }

    public long getL2CacheHitCount() {
        return this.l2Stats != null ? this.l2Stats.getHitCount() : 0L;
    }

    public long getL2CacheMissCount() {
        return this.l2Stats != null ? this.l2Stats.getMissCount() : 0L;
    }

    public double getL2CacheHitRatio() {
        return this.l2Stats != null ? this.l2Stats.getHitRatio() : 0.0;
    }

    public double getL2CacheMissRatio() {
        return this.l2Stats != null ? this.l2Stats.getMissRatio() : 0.0;
    }

    public void forceRecompute() {
        this.runnable.run();
    }

    public long getNumStores() {
        return this.aggregate.numStores;
    }

    public long getNumWALFiles() {
        return this.numWALFiles;
    }

    public long getWALFileSize() {
        return this.walFileSize;
    }

    public List<String> getWALExcludeDNs() {
        if (this.excludeDatanodeManager == null) {
            return Collections.emptyList();
        }
        return this.excludeDatanodeManager.getExcludeDNs().entrySet().stream().map(e -> ((DatanodeInfo)e.getKey()).toString() + ", " + e.getValue()).collect(Collectors.toList());
    }

    public long getNumWALSlowAppend() {
        return this.metricsWALSource.getSlowAppendCount();
    }

    public long getNumStoreFiles() {
        return this.aggregate.numStoreFiles;
    }

    public long getMaxStoreFiles() {
        return this.aggregate.maxStoreFileCount;
    }

    public long getMaxStoreFileAge() {
        return this.aggregate.maxStoreFileAge;
    }

    public long getMinStoreFileAge() {
        return this.aggregate.minStoreFileAge;
    }

    public long getAvgStoreFileAge() {
        return this.aggregate.avgStoreFileAge;
    }

    public long getNumReferenceFiles() {
        return this.aggregate.numReferenceFiles;
    }

    public long getMemStoreSize() {
        return this.aggregate.memstoreSize;
    }

    public long getOnHeapMemStoreSize() {
        return this.aggregate.onHeapMemstoreSize;
    }

    public long getOffHeapMemStoreSize() {
        return this.aggregate.offHeapMemstoreSize;
    }

    public long getStoreFileSize() {
        return this.aggregate.storeFileSize;
    }

    public double getRequestsPerSecond() {
        return this.aggregate.requestsPerSecond;
    }

    public long getReadRequestsCount() {
        return this.aggregate.readRequestsCount;
    }

    public double getReadRequestsRatePerSecond() {
        return this.aggregate.readRequestsRatePerSecond;
    }

    public long getFilteredReadRequestsCount() {
        return this.aggregate.filteredReadRequestsCount;
    }

    public long getWriteRequestsCount() {
        return this.aggregate.writeRequestsCount;
    }

    public double getWriteRequestsRatePerSecond() {
        return this.aggregate.writeRequestsRatePerSecond;
    }

    public long getRpcGetRequestsCount() {
        return this.regionServer.rpcServices.rpcGetRequestCount.sum();
    }

    public long getRpcScanRequestsCount() {
        return this.regionServer.rpcServices.rpcScanRequestCount.sum();
    }

    public long getRpcFullScanRequestsCount() {
        return this.regionServer.rpcServices.rpcFullScanRequestCount.sum();
    }

    public long getRpcMultiRequestsCount() {
        return this.regionServer.rpcServices.rpcMultiRequestCount.sum();
    }

    public long getRpcMutateRequestsCount() {
        return this.regionServer.rpcServices.rpcMutateRequestCount.sum();
    }

    public long getCheckAndMutateChecksFailed() {
        return this.aggregate.checkAndMutateChecksFailed;
    }

    public long getCheckAndMutateChecksPassed() {
        return this.aggregate.checkAndMutateChecksPassed;
    }

    public long getStoreFileIndexSize() {
        return this.aggregate.storefileIndexSize;
    }

    public long getTotalStaticIndexSize() {
        return this.aggregate.totalStaticIndexSize;
    }

    public long getTotalStaticBloomSize() {
        return this.aggregate.totalStaticBloomSize;
    }

    public long getBloomFilterRequestsCount() {
        return this.aggregate.bloomFilterRequestsCount;
    }

    public long getBloomFilterNegativeResultsCount() {
        return this.aggregate.bloomFilterNegativeResultsCount;
    }

    public long getBloomFilterEligibleRequestsCount() {
        return this.aggregate.bloomFilterEligibleRequestsCount;
    }

    public long getNumMutationsWithoutWAL() {
        return this.aggregate.numMutationsWithoutWAL;
    }

    public long getDataInMemoryWithoutWAL() {
        return this.aggregate.dataInMemoryWithoutWAL;
    }

    public double getPercentFileLocal() {
        return this.aggregate.percentFileLocal;
    }

    public double getPercentFileLocalPrimaryRegions() {
        return this.aggregate.percentFileLocalPrimaryRegions;
    }

    public double getPercentFileLocalSecondaryRegions() {
        return this.aggregate.percentFileLocalSecondaryRegions;
    }

    public long getUpdatesBlockedTime() {
        if (this.regionServer.getMemStoreFlusher() == null) {
            return 0L;
        }
        return this.regionServer.getMemStoreFlusher().getUpdatesBlockedMsHighWater().sum();
    }

    public long getFlushedCellsCount() {
        return this.aggregate.flushedCellsCount;
    }

    public long getCompactedCellsCount() {
        return this.aggregate.compactedCellsCount;
    }

    public long getMajorCompactedCellsCount() {
        return this.aggregate.majorCompactedCellsCount;
    }

    public long getFlushedCellsSize() {
        return this.aggregate.flushedCellsSize;
    }

    public long getCompactedCellsSize() {
        return this.aggregate.compactedCellsSize;
    }

    public long getMajorCompactedCellsSize() {
        return this.aggregate.majorCompactedCellsSize;
    }

    public long getCellsCountCompactedFromMob() {
        return this.aggregate.cellsCountCompactedFromMob;
    }

    public long getCellsCountCompactedToMob() {
        return this.aggregate.cellsCountCompactedToMob;
    }

    public long getCellsSizeCompactedFromMob() {
        return this.aggregate.cellsSizeCompactedFromMob;
    }

    public long getCellsSizeCompactedToMob() {
        return this.aggregate.cellsSizeCompactedToMob;
    }

    public long getMobFlushCount() {
        return this.aggregate.mobFlushCount;
    }

    public long getMobFlushedCellsCount() {
        return this.aggregate.mobFlushedCellsCount;
    }

    public long getMobFlushedCellsSize() {
        return this.aggregate.mobFlushedCellsSize;
    }

    public long getMobScanCellsCount() {
        return this.aggregate.mobScanCellsCount;
    }

    public long getMobScanCellsSize() {
        return this.aggregate.mobScanCellsSize;
    }

    public long getMobFileCacheAccessCount() {
        return this.mobFileCacheAccessCount;
    }

    public long getMobFileCacheMissCount() {
        return this.mobFileCacheMissCount;
    }

    public long getMobFileCacheCount() {
        return this.mobFileCacheCount;
    }

    public long getMobFileCacheEvictedCount() {
        return this.mobFileCacheEvictedCount;
    }

    public double getMobFileCacheHitPercent() {
        return this.mobFileCacheHitRatio * 100.0;
    }

    public int getActiveScanners() {
        return this.regionServer.getRSRpcServices().getScannersCount();
    }

    public long getHedgedReadOps() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOps();
    }

    public long getHedgedReadWins() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadWins();
    }

    public long getHedgedReadOpsInCurThread() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOpsInCurThread();
    }

    public long getTotalBytesRead() {
        return FSDataInputStreamWrapper.getTotalBytesRead();
    }

    public long getLocalBytesRead() {
        return FSDataInputStreamWrapper.getLocalBytesRead();
    }

    public long getShortCircuitBytesRead() {
        return FSDataInputStreamWrapper.getShortCircuitBytesRead();
    }

    public long getZeroCopyBytesRead() {
        return FSDataInputStreamWrapper.getZeroCopyBytesRead();
    }

    public long getBlockedRequestsCount() {
        return this.aggregate.blockedRequestsCount;
    }

    public long getAverageRegionSize() {
        return this.aggregate.averageRegionSize;
    }

    public long getDataMissCount() {
        return this.cacheStats != null ? this.cacheStats.getDataMissCount() : 0L;
    }

    public long getLeafIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getLeafIndexMissCount() : 0L;
    }

    public long getBloomChunkMissCount() {
        return this.cacheStats != null ? this.cacheStats.getBloomChunkMissCount() : 0L;
    }

    public long getMetaMissCount() {
        return this.cacheStats != null ? this.cacheStats.getMetaMissCount() : 0L;
    }

    public long getRootIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getRootIndexMissCount() : 0L;
    }

    public long getIntermediateIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getIntermediateIndexMissCount() : 0L;
    }

    public long getFileInfoMissCount() {
        return this.cacheStats != null ? this.cacheStats.getFileInfoMissCount() : 0L;
    }

    public long getGeneralBloomMetaMissCount() {
        return this.cacheStats != null ? this.cacheStats.getGeneralBloomMetaMissCount() : 0L;
    }

    public long getDeleteFamilyBloomMissCount() {
        return this.cacheStats != null ? this.cacheStats.getDeleteFamilyBloomMissCount() : 0L;
    }

    public long getTrailerMissCount() {
        return this.cacheStats != null ? this.cacheStats.getTrailerMissCount() : 0L;
    }

    public long getDataHitCount() {
        return this.cacheStats != null ? this.cacheStats.getDataHitCount() : 0L;
    }

    public long getLeafIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getLeafIndexHitCount() : 0L;
    }

    public long getBloomChunkHitCount() {
        return this.cacheStats != null ? this.cacheStats.getBloomChunkHitCount() : 0L;
    }

    public long getMetaHitCount() {
        return this.cacheStats != null ? this.cacheStats.getMetaHitCount() : 0L;
    }

    public long getRootIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getRootIndexHitCount() : 0L;
    }

    public long getIntermediateIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getIntermediateIndexHitCount() : 0L;
    }

    public long getFileInfoHitCount() {
        return this.cacheStats != null ? this.cacheStats.getFileInfoHitCount() : 0L;
    }

    public long getGeneralBloomMetaHitCount() {
        return this.cacheStats != null ? this.cacheStats.getGeneralBloomMetaHitCount() : 0L;
    }

    public long getDeleteFamilyBloomHitCount() {
        return this.cacheStats != null ? this.cacheStats.getDeleteFamilyBloomHitCount() : 0L;
    }

    public long getTrailerHitCount() {
        return this.cacheStats != null ? this.cacheStats.getTrailerHitCount() : 0L;
    }

    public long getByteBuffAllocatorHeapAllocationBytes() {
        return ByteBuffAllocator.getHeapAllocationBytes((ByteBuffAllocator[])new ByteBuffAllocator[]{this.allocator, ByteBuffAllocator.HEAP});
    }

    public long getByteBuffAllocatorPoolAllocationBytes() {
        return this.allocator.getPoolAllocationBytes();
    }

    public double getByteBuffAllocatorHeapAllocRatio() {
        return ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{this.allocator, ByteBuffAllocator.HEAP});
    }

    public long getByteBuffAllocatorTotalBufferCount() {
        return this.allocator.getTotalBufferCount();
    }

    public long getByteBuffAllocatorUsedBufferCount() {
        return this.allocator.getUsedBufferCount();
    }

    long getPeriod() {
        return this.period;
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;

        @Override
        public synchronized void run() {
            try {
                long timeSinceLastRun;
                RegionMetricAggregate newVal = new RegionMetricAggregate(MetricsRegionServerWrapperImpl.this.aggregate);
                newVal.aggregate(MetricsRegionServerWrapperImpl.this.regionServer, MetricsRegionServerWrapperImpl.this.requestsCountCache);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.lastRan == 0L) {
                    this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period;
                }
                if ((timeSinceLastRun = currentTime - this.lastRan) > 0L) {
                    newVal.updateRates(timeSinceLastRun, MetricsRegionServerWrapperImpl.this.period);
                }
                MetricsRegionServerWrapperImpl.this.aggregate = newVal;
                WALProvider provider = MetricsRegionServerWrapperImpl.this.regionServer.getWalFactory().getWALProvider();
                WALProvider metaProvider = MetricsRegionServerWrapperImpl.this.regionServer.getWalFactory().getMetaWALProvider();
                MetricsRegionServerWrapperImpl.this.numWALFiles = (provider == null ? 0L : provider.getNumLogFiles()) + (metaProvider == null ? 0L : metaProvider.getNumLogFiles());
                MetricsRegionServerWrapperImpl.this.walFileSize = (provider == null ? 0L : provider.getLogFileSize()) + (metaProvider == null ? 0L : metaProvider.getLogFileSize());
                MetricsRegionServerWrapperImpl.this.mobFileCacheAccessCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getAccessCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheMissCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getMissCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getHitRatio() : 0.0;
                if (Double.isNaN(MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio)) {
                    MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = 0.0;
                }
                MetricsRegionServerWrapperImpl.this.mobFileCacheEvictedCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getEvictedFileCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? (long)MetricsRegionServerWrapperImpl.this.mobFileCache.getCacheSize() : 0L;
                this.lastRan = currentTime;
            }
            catch (Throwable e) {
                LOG.warn("Caught exception! Will suppress and retry.", e);
            }
        }
    }

    private static final class RegionMetricAggregate {
        private long numStores = 0L;
        private long numStoreFiles = 0L;
        private long memstoreSize = 0L;
        private long onHeapMemstoreSize = 0L;
        private long offHeapMemstoreSize = 0L;
        private long storeFileSize = 0L;
        private long maxStoreFileCount = 0L;
        private long maxStoreFileAge = 0L;
        private long minStoreFileAge = Long.MAX_VALUE;
        private long avgStoreFileAge = 0L;
        private long numReferenceFiles = 0L;
        private double requestsPerSecond = 0.0;
        private long readRequestsCount = 0L;
        private double readRequestsRatePerSecond = 0.0;
        private long filteredReadRequestsCount = 0L;
        private long writeRequestsCount = 0L;
        private double writeRequestsRatePerSecond = 0.0;
        private long checkAndMutateChecksFailed = 0L;
        private long checkAndMutateChecksPassed = 0L;
        private long storefileIndexSize = 0L;
        private long totalStaticIndexSize = 0L;
        private long totalStaticBloomSize = 0L;
        private long bloomFilterRequestsCount = 0L;
        private long bloomFilterNegativeResultsCount = 0L;
        private long bloomFilterEligibleRequestsCount = 0L;
        private long numMutationsWithoutWAL = 0L;
        private long dataInMemoryWithoutWAL = 0L;
        private double percentFileLocal = 0.0;
        private double percentFileLocalPrimaryRegions = 0.0;
        private double percentFileLocalSecondaryRegions = 0.0;
        private long flushedCellsCount = 0L;
        private long compactedCellsCount = 0L;
        private long majorCompactedCellsCount = 0L;
        private long flushedCellsSize = 0L;
        private long compactedCellsSize = 0L;
        private long majorCompactedCellsSize = 0L;
        private long cellsCountCompactedToMob = 0L;
        private long cellsCountCompactedFromMob = 0L;
        private long cellsSizeCompactedToMob = 0L;
        private long cellsSizeCompactedFromMob = 0L;
        private long mobFlushCount = 0L;
        private long mobFlushedCellsCount = 0L;
        private long mobFlushedCellsSize = 0L;
        private long mobScanCellsCount = 0L;
        private long mobScanCellsSize = 0L;
        private long blockedRequestsCount = 0L;
        private long averageRegionSize = 0L;
        private long totalReadRequestsDelta = 0L;
        private long totalWriteRequestsDelta = 0L;

        private RegionMetricAggregate(RegionMetricAggregate other) {
            if (other != null) {
                this.requestsPerSecond = other.requestsPerSecond;
                this.readRequestsRatePerSecond = other.readRequestsRatePerSecond;
                this.writeRequestsRatePerSecond = other.writeRequestsRatePerSecond;
            }
        }

        private void aggregate(HRegionServer regionServer, Map<String, ArrayList<Long>> requestsCountCache) {
            HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
            HDFSBlocksDistribution hdfsBlocksDistributionPrimaryRegions = new HDFSBlocksDistribution();
            HDFSBlocksDistribution hdfsBlocksDistributionSecondaryRegions = new HDFSBlocksDistribution();
            long avgAgeNumerator = 0L;
            long numHFiles = 0L;
            int regionCount = 0;
            for (HRegion r : regionServer.getOnlineRegionsLocalContext()) {
                Deltas deltas = this.calculateReadWriteDeltas(r, requestsCountCache);
                this.totalReadRequestsDelta += deltas.readRequestsCountDelta;
                this.totalWriteRequestsDelta += deltas.writeRequestsCountDelta;
                this.numMutationsWithoutWAL += r.getNumMutationsWithoutWAL();
                this.dataInMemoryWithoutWAL += r.getDataInMemoryWithoutWAL();
                this.readRequestsCount += r.getReadRequestsCount();
                this.filteredReadRequestsCount += r.getFilteredReadRequestsCount();
                this.writeRequestsCount += r.getWriteRequestsCount();
                this.checkAndMutateChecksFailed += r.getCheckAndMutateChecksFailed();
                this.checkAndMutateChecksPassed += r.getCheckAndMutateChecksPassed();
                this.blockedRequestsCount += r.getBlockedRequestsCount();
                StoreFileStats storeFileStats = this.aggregateStores(r.getStores());
                numHFiles += storeFileStats.numHFiles;
                avgAgeNumerator += storeFileStats.avgAgeNumerator;
                HDFSBlocksDistribution distro = r.getHDFSBlocksDistribution();
                hdfsBlocksDistribution.add(distro);
                if (r.getRegionInfo().getReplicaId() == 0) {
                    hdfsBlocksDistributionPrimaryRegions.add(distro);
                }
                if (r.getRegionInfo().getReplicaId() != 0) {
                    hdfsBlocksDistributionSecondaryRegions.add(distro);
                }
                ++regionCount;
            }
            float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(regionServer.getServerName().getHostname());
            this.percentFileLocal = Double.isNaN(localityIndex) ? 0.0 : (double)(localityIndex * 100.0f);
            float localityIndexPrimaryRegions = hdfsBlocksDistributionPrimaryRegions.getBlockLocalityIndex(regionServer.getServerName().getHostname());
            this.percentFileLocalPrimaryRegions = Double.isNaN(localityIndexPrimaryRegions) ? 0.0 : (double)(localityIndexPrimaryRegions * 100.0f);
            float localityIndexSecondaryRegions = hdfsBlocksDistributionSecondaryRegions.getBlockLocalityIndex(regionServer.getServerName().getHostname());
            double d = this.percentFileLocalSecondaryRegions = Double.isNaN(localityIndexSecondaryRegions) ? 0.0 : (double)(localityIndexSecondaryRegions * 100.0f);
            if (regionCount > 0) {
                this.averageRegionSize = (this.memstoreSize + this.storeFileSize) / (long)regionCount;
            }
            if (this.minStoreFileAge == Long.MAX_VALUE) {
                this.minStoreFileAge = 0L;
            }
            if (numHFiles != 0L) {
                this.avgStoreFileAge = avgAgeNumerator / numHFiles;
            }
        }

        private Deltas calculateReadWriteDeltas(HRegion r, Map<String, ArrayList<Long>> requestsCountCache) {
            String encodedRegionName = r.getRegionInfo().getEncodedName();
            long currentReadRequestsCount = r.getReadRequestsCount();
            long currentWriteRequestsCount = r.getWriteRequestsCount();
            if (requestsCountCache.containsKey(encodedRegionName)) {
                long lastReadRequestsCount = requestsCountCache.get(encodedRegionName).get(0);
                long lastWriteRequestsCount = requestsCountCache.get(encodedRegionName).get(1);
                requestsCountCache.get(encodedRegionName).set(0, currentReadRequestsCount);
                requestsCountCache.get(encodedRegionName).set(1, currentWriteRequestsCount);
                long readRequestsDelta = currentReadRequestsCount - lastReadRequestsCount;
                long writeRequestsDelta = currentWriteRequestsCount - lastWriteRequestsCount;
                return new Deltas(readRequestsDelta, writeRequestsDelta);
            }
            ArrayList<Long> requests = new ArrayList<Long>(2);
            requests.add(currentReadRequestsCount);
            requests.add(currentWriteRequestsCount);
            requestsCountCache.put(encodedRegionName, requests);
            return new Deltas(currentReadRequestsCount, currentWriteRequestsCount);
        }

        public void updateRates(long timeSinceLastRun, long expectedPeriod) {
            this.requestsPerSecond = (double)(this.totalReadRequestsDelta + this.totalWriteRequestsDelta) / ((double)timeSinceLastRun / 1000.0);
            double readRequestsRatePerMilliSecond = (double)this.totalReadRequestsDelta / (double)expectedPeriod;
            double writeRequestsRatePerMilliSecond = (double)this.totalWriteRequestsDelta / (double)expectedPeriod;
            this.readRequestsRatePerSecond = readRequestsRatePerMilliSecond * 1000.0;
            this.writeRequestsRatePerSecond = writeRequestsRatePerMilliSecond * 1000.0;
        }

        private StoreFileStats aggregateStores(List<HStore> stores) {
            this.numStores += (long)stores.size();
            long numHFiles = 0L;
            long avgAgeNumerator = 0L;
            for (Store store : stores) {
                this.numStoreFiles += (long)store.getStorefilesCount();
                this.memstoreSize += store.getMemStoreSize().getDataSize();
                this.onHeapMemstoreSize += store.getMemStoreSize().getHeapSize();
                this.offHeapMemstoreSize += store.getMemStoreSize().getOffHeapSize();
                this.storeFileSize += store.getStorefilesSize();
                this.maxStoreFileCount = Math.max(this.maxStoreFileCount, (long)store.getStorefilesCount());
                this.maxStoreFileAge = Math.max(store.getMaxStoreFileAge().orElse(this.maxStoreFileAge), this.maxStoreFileAge);
                this.minStoreFileAge = Math.min(store.getMinStoreFileAge().orElse(this.minStoreFileAge), this.minStoreFileAge);
                long storeHFiles = store.getNumHFiles();
                numHFiles += storeHFiles;
                this.numReferenceFiles += store.getNumReferenceFiles();
                OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                if (storeAvgStoreFileAge.isPresent()) {
                    avgAgeNumerator = (long)((double)avgAgeNumerator + storeAvgStoreFileAge.getAsDouble() * (double)storeHFiles);
                }
                this.storefileIndexSize += store.getStorefilesRootLevelIndexSize();
                this.totalStaticBloomSize += store.getTotalStaticBloomSize();
                this.totalStaticIndexSize += store.getTotalStaticIndexSize();
                this.bloomFilterRequestsCount += store.getBloomFilterRequestsCount();
                this.bloomFilterNegativeResultsCount += store.getBloomFilterNegativeResultsCount();
                this.bloomFilterEligibleRequestsCount += store.getBloomFilterEligibleRequestsCount();
                this.flushedCellsCount += store.getFlushedCellsCount();
                this.compactedCellsCount += store.getCompactedCellsCount();
                this.majorCompactedCellsCount += store.getMajorCompactedCellsCount();
                this.flushedCellsSize += store.getFlushedCellsSize();
                this.compactedCellsSize += store.getCompactedCellsSize();
                this.majorCompactedCellsSize += store.getMajorCompactedCellsSize();
                if (!(store instanceof HMobStore)) continue;
                HMobStore mobStore = (HMobStore)store;
                this.cellsCountCompactedToMob += mobStore.getCellsCountCompactedToMob();
                this.cellsCountCompactedFromMob += mobStore.getCellsCountCompactedFromMob();
                this.cellsSizeCompactedToMob += mobStore.getCellsSizeCompactedToMob();
                this.cellsSizeCompactedFromMob += mobStore.getCellsSizeCompactedFromMob();
                this.mobFlushCount += mobStore.getMobFlushCount();
                this.mobFlushedCellsCount += mobStore.getMobFlushedCellsCount();
                this.mobFlushedCellsSize += mobStore.getMobFlushedCellsSize();
                this.mobScanCellsCount += mobStore.getMobScanCellsCount();
                this.mobScanCellsSize += mobStore.getMobScanCellsSize();
            }
            return new StoreFileStats(numHFiles, avgAgeNumerator);
        }

        private static final class StoreFileStats {
            private final long numHFiles;
            private final long avgAgeNumerator;

            private StoreFileStats(long numHFiles, long avgAgeNumerator) {
                this.numHFiles = numHFiles;
                this.avgAgeNumerator = avgAgeNumerator;
            }
        }

        private static final class Deltas {
            private final long readRequestsCountDelta;
            private final long writeRequestsCountDelta;

            private Deltas(long readRequestsCountDelta, long writeRequestsCountDelta) {
                this.readRequestsCountDelta = readRequestsCountDelta;
                this.writeRequestsCountDelta = writeRequestsCountDelta;
            }
        }
    }
}

