/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FastPathRpcHandler
extends RpcHandler {
    final Deque<FastPathRpcHandler> fastPathHandlerStack;
    private Semaphore semaphore = new Semaphore(0);
    private CallRunner loadedCallRunner;

    FastPathRpcHandler(String name, double handlerFailureThreshhold, int handlerCount, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, AtomicInteger failedHandlerCount, Abortable abortable, Deque<FastPathRpcHandler> fastPathHandlerStack) {
        super(name, handlerFailureThreshhold, handlerCount, q, activeHandlerCount, failedHandlerCount, abortable);
        this.fastPathHandlerStack = fastPathHandlerStack;
    }

    @Override
    protected CallRunner getCallRunner() throws InterruptedException {
        CallRunner cr = (CallRunner)this.q.poll();
        if (cr == null) {
            if (this.fastPathHandlerStack != null) {
                this.fastPathHandlerStack.push(this);
                this.semaphore.acquire();
                cr = this.loadedCallRunner;
                this.loadedCallRunner = null;
            } else {
                cr = super.getCallRunner();
            }
        }
        return cr;
    }

    boolean loadCallRunner(CallRunner cr) {
        this.loadedCallRunner = cr;
        this.semaphore.release();
        return true;
    }
}

