/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFileReaderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileStreamReader;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFilePreadReader
extends HFileReaderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HFileReaderImpl.class);

    public HFilePreadReader(final ReaderContext context, final HFileInfo fileInfo, final CacheConfig cacheConf, final Configuration conf) throws IOException {
        super(context, fileInfo, cacheConf, conf);
        if (cacheConf.getBlockCache().isPresent() && cacheConf.shouldPrefetchOnOpen()) {
            PrefetchExecutor.request(this.path, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long offset = 0L;
                    long end = 0L;
                    HFile.Reader prefetchStreamReader = null;
                    try {
                        ReaderContext streamReaderContext = ReaderContextBuilder.newBuilder(context).withReaderType(ReaderContext.ReaderType.STREAM).withInputStreamWrapper(new FSDataInputStreamWrapper((FileSystem)context.getFileSystem(), context.getInputStreamWrapper().getReaderPath())).build();
                        prefetchStreamReader = new HFileStreamReader(streamReaderContext, fileInfo, cacheConf, conf);
                        end = HFilePreadReader.this.getTrailer().getLoadOnOpenDataOffset();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Prefetch start " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end));
                        }
                        long onDiskSizeOfNextBlock = -1L;
                        BlockCache cache = cacheConf.getBlockCache().get();
                        boolean interrupted = false;
                        int blockCount = 0;
                        int dataBlockCount = 0;
                        while (offset < end && !Thread.interrupted()) {
                            BlockCacheKey cacheKey = new BlockCacheKey(HFilePreadReader.this.name, offset);
                            if (cache.isAlreadyCached(cacheKey).orElse(false).booleanValue()) {
                                int size = cache.getBlockSize(cacheKey).orElse(0);
                                if (size > 0) {
                                    offset += (long)size;
                                    LOG.debug("Found block of size {} for cache key {}. Skipping prefetch, the block is already cached.", (Object)size, (Object)cacheKey);
                                    ++blockCount;
                                    ++dataBlockCount;
                                    continue;
                                }
                                LOG.debug("Found block for cache key {}, but couldn't get its size. Maybe the cache implementation doesn't support it? We'll need to read the block from cache or file system. ", (Object)cacheKey);
                            } else {
                                LOG.debug("No entry in the backing map for cache key {}. ", (Object)cacheKey);
                            }
                            HFileBlock block = prefetchStreamReader.readBlock(offset, onDiskSizeOfNextBlock, true, false, false, false, null, null, true);
                            try {
                                if (!cacheConf.isInMemory() && !cache.blockFitsIntoTheCache(block).orElse(true).booleanValue()) {
                                    LOG.warn("Interrupting prefetch for file {} because block {} of size {} doesn't fit in the available cache space.", new Object[]{HFilePreadReader.this.path, cacheKey, block.getOnDiskSizeWithHeader()});
                                    interrupted = true;
                                    break;
                                }
                                onDiskSizeOfNextBlock = block.getNextBlockOnDiskSize();
                                offset += (long)block.getOnDiskSizeWithHeader();
                                ++blockCount;
                                if (!block.getBlockType().isData()) continue;
                                ++dataBlockCount;
                            }
                            finally {
                                block.release();
                            }
                        }
                        if (!interrupted) {
                            cacheConf.getBlockCache().get().notifyFileCachingCompleted(HFilePreadReader.this.path, blockCount, dataBlockCount, offset);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Prefetch " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end), (Throwable)e);
                        }
                    }
                    catch (Throwable e) {
                        LOG.warn("Prefetch " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end), e);
                    }
                    finally {
                        if (prefetchStreamReader != null) {
                            try {
                                prefetchStreamReader.close(false);
                            }
                            catch (IOException e) {
                                LOG.warn("Close prefetch stream reader failed, path: " + HFilePreadReader.this.path, (Throwable)e);
                            }
                        }
                        PrefetchExecutor.complete(HFilePreadReader.this.path);
                    }
                }
            });
        }
    }

    private static String getRegionName(Path path) {
        return path.getParent().getParent().getName();
    }

    private static String getPathOffsetEndStr(Path path, long offset, long end) {
        return "path=" + path.toString() + ", offset=" + offset + ", end=" + end;
    }

    @Override
    public void close(boolean evictOnClose) throws IOException {
        PrefetchExecutor.cancel(this.path);
        this.fileInfo.close();
        this.cacheConf.getBlockCache().ifPresent(cache -> {
            if (evictOnClose) {
                int numEvicted = cache.evictBlocksByHfileName(this.name);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("On close, file= {} evicted= {} block(s)", (Object)this.name, (Object)numEvicted);
                }
            }
        });
        this.fsBlockReader.closeStreams();
    }
}

