/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.FlushRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FlushTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.FlushTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(FlushTableProcedure.class);
    private TableName tableName;
    private List<byte[]> columnFamilies;

    public FlushTableProcedure() {
    }

    public FlushTableProcedure(MasterProcedureEnv env, TableName tableName) {
        this(env, tableName, null);
    }

    public FlushTableProcedure(MasterProcedureEnv env, TableName tableName, List<byte[]> columnFamilies) {
        super(env);
        this.tableName = tableName;
        this.columnFamilies = columnFamilies;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitTableSharedLock((Procedure<?>)this, this.getTableName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeTableSharedLock((Procedure<?>)this, this.getTableName());
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.FlushTableState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        LOG.info("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case FLUSH_TABLE_PREPARE: {
                    this.preflightChecks(env, true);
                    this.setNextState(MasterProcedureProtos.FlushTableState.FLUSH_TABLE_FLUSH_REGIONS);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case FLUSH_TABLE_FLUSH_REGIONS: {
                    this.addChildProcedure(this.createFlushRegionProcedures(env));
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (Exception e) {
            if (e instanceof DoNotRetryIOException) {
                this.setFailure("master-flush-table", e);
                LOG.warn("Unrecoverable error trying to flush " + this.getTableName() + " state=" + state, (Throwable)e);
            } else {
                LOG.warn("Retriable error trying to flush " + this.getTableName() + " state=" + state, (Throwable)e);
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
    }

    @Override
    protected void preflightChecks(MasterProcedureEnv env, Boolean enabled) throws HBaseIOException {
        super.preflightChecks(env, enabled);
        if (this.columnFamilies == null) {
            return;
        }
        MasterServices master = env.getMasterServices();
        try {
            TableDescriptor tableDescriptor = master.getTableDescriptors().get(this.tableName);
            List noSuchFamilies = this.columnFamilies.stream().filter(cf -> !tableDescriptor.hasColumnFamily(cf)).map(Bytes::toString).collect(Collectors.toList());
            if (!noSuchFamilies.isEmpty()) {
                throw new NoSuchColumnFamilyException("Column families " + noSuchFamilies + " don't exist in table " + this.tableName.getNameAsString());
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)((Object)ioe);
            }
            throw new HBaseIOException((Throwable)ioe);
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.FlushTableState state) throws IOException, InterruptedException {
    }

    protected MasterProcedureProtos.FlushTableState getState(int stateId) {
        return MasterProcedureProtos.FlushTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.FlushTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.FlushTableState getInitialState() {
        return MasterProcedureProtos.FlushTableState.FLUSH_TABLE_PREPARE;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.FLUSH;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.FlushTableProcedureStateData.Builder builder = MasterProcedureProtos.FlushTableProcedureStateData.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        if (this.columnFamilies != null) {
            for (byte[] columnFamily : this.columnFamilies) {
                if (columnFamily == null || columnFamily.length <= 0) continue;
                builder.addColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])columnFamily));
            }
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.FlushTableProcedureStateData data = (MasterProcedureProtos.FlushTableProcedureStateData)serializer.deserialize(MasterProcedureProtos.FlushTableProcedureStateData.class);
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)data.getTableName());
        if (data.getColumnFamilyCount() > 0) {
            this.columnFamilies = data.getColumnFamilyList().stream().filter(cf -> !cf.isEmpty()).map(ByteString::toByteArray).collect(Collectors.toList());
        }
    }

    private FlushRegionProcedure[] createFlushRegionProcedures(MasterProcedureEnv env) {
        return (FlushRegionProcedure[])env.getAssignmentManager().getTableRegions(this.getTableName(), true).stream().filter(r -> RegionReplicaUtil.isDefaultReplica((RegionInfo)r)).map(r -> new FlushRegionProcedure((RegionInfo)r, this.columnFamilies)).toArray(FlushRegionProcedure[]::new);
    }

    @Override
    public void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getName()).append(", id=").append(this.getProcId()).append(", table=").append(this.tableName);
        if (this.columnFamilies != null) {
            builder.append(", columnFamilies=[").append(Strings.JOINER.join((Iterable)this.columnFamilies.stream().map(Bytes::toString).collect(Collectors.toList()))).append("]");
        }
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (!env.getMasterConfiguration().getBoolean("hbase.flush.procedure.enabled", true)) {
            this.setFailure("master-flush-table", new HBaseIOException("FlushTableProcedureV2 is DISABLED"));
        }
    }
}

