/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.master.MetricsMasterProcSource;
import org.apache.hadoop.hbase.master.MetricsMasterProcSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterQuotaSource;
import org.apache.hadoop.hbase.master.MetricsMasterQuotaSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.OperationMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsMaster {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsMaster.class);
    private MetricsMasterSource masterSource;
    private MetricsMasterProcSource masterProcSource;
    private MetricsMasterQuotaSource masterQuotaSource;
    private ProcedureMetrics serverCrashProcMetrics;

    public MetricsMaster(MetricsMasterWrapper masterWrapper) {
        this.masterSource = ((MetricsMasterSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterSourceFactory.class)).create(masterWrapper);
        this.masterProcSource = ((MetricsMasterProcSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterProcSourceFactory.class)).create(masterWrapper);
        this.masterQuotaSource = ((MetricsMasterQuotaSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterQuotaSourceFactory.class)).create(masterWrapper);
        this.serverCrashProcMetrics = MetricsMaster.convertToProcedureMetrics(this.masterSource.getServerCrashMetrics());
    }

    public MetricsMasterSource getMetricsSource() {
        return this.masterSource;
    }

    public MetricsMasterProcSource getMetricsProcSource() {
        return this.masterProcSource;
    }

    public MetricsMasterQuotaSource getMetricsQuotaSource() {
        return this.masterQuotaSource;
    }

    public void incrementRequests(long inc) {
        this.masterSource.incRequests(inc);
    }

    public void setNumSpaceQuotas(long numSpaceQuotas) {
        this.masterQuotaSource.updateNumSpaceQuotas(numSpaceQuotas);
    }

    public void setNumTableInSpaceQuotaViolation(long numTablesInViolation) {
        this.masterQuotaSource.updateNumTablesInSpaceQuotaViolation(numTablesInViolation);
    }

    public void setNumNamespacesInSpaceQuotaViolation(long numNamespacesInViolation) {
        this.masterQuotaSource.updateNumNamespacesInSpaceQuotaViolation(numNamespacesInViolation);
    }

    public void setNumRegionSizeReports(long numRegionReports) {
        this.masterQuotaSource.updateNumCurrentSpaceQuotaRegionSizeReports(numRegionReports);
    }

    public void incrementQuotaObserverTime(long executionTime) {
        this.masterQuotaSource.incrementSpaceQuotaObserverChoreTime(executionTime);
    }

    public ProcedureMetrics getServerCrashProcMetrics() {
        return this.serverCrashProcMetrics;
    }

    public static ProcedureMetrics convertToProcedureMetrics(final OperationMetrics metrics) {
        return new ProcedureMetrics(){

            public Counter getSubmittedCounter() {
                return metrics.getSubmittedCounter();
            }

            public Histogram getTimeHisto() {
                return metrics.getTimeHisto();
            }

            public Counter getFailedCounter() {
                return metrics.getFailedCounter();
            }
        };
    }

    public void incrementSnapshotObserverTime(long executionTime) {
        this.masterQuotaSource.incrementSnapshotObserverChoreTime(executionTime);
    }

    public void incrementSnapshotSizeComputationTime(long executionTime) {
        this.masterQuotaSource.incrementSnapshotObserverSnapshotComputationTime(executionTime);
    }

    public void incrementSnapshotFetchTime(long executionTime) {
        this.masterQuotaSource.incrementSnapshotObserverSnapshotFetchTime(executionTime);
    }
}

