/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SnapshotScannerHDFSAclController
implements MasterCoprocessor,
MasterObserver {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotScannerHDFSAclController.class);
    private SnapshotScannerHDFSAclHelper hdfsAclHelper = null;
    private SnapshotScannerHDFSAclHelper.PathHelper pathHelper = null;
    private MasterServices masterServices = null;
    private volatile boolean initialized = false;
    private volatile boolean aclTableInitialized = false;
    private UserProvider userProvider;

    @Override
    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    @Override
    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (c.getEnvironment().getConfiguration().getBoolean("hbase.acl.sync.to.hdfs.enable", false)) {
            MasterCoprocessorEnvironment mEnv = c.getEnvironment();
            if (!(mEnv instanceof HasMasterServices)) {
                throw new IOException("Does not implement HMasterServices");
            }
            this.masterServices = ((HasMasterServices)((Object)mEnv)).getMasterServices();
            this.hdfsAclHelper = new SnapshotScannerHDFSAclHelper(this.masterServices.getConfiguration(), this.masterServices.getConnection());
            this.pathHelper = this.hdfsAclHelper.getPathHelper();
            this.hdfsAclHelper.setCommonDirectoryPermission();
            this.initialized = true;
            this.userProvider = UserProvider.instantiate((Configuration)c.getEnvironment().getConfiguration());
        } else {
            LOG.warn("Try to initialize the coprocessor SnapshotScannerHDFSAclController but failure because the config hbase.acl.sync.to.hdfs.enable is false.");
        }
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        block15: {
            if (!this.initialized) {
                return;
            }
            try (Admin admin = c.getEnvironment().getConnection().getAdmin();){
                if (admin.tableExists(PermissionStorage.ACL_TABLE_NAME)) {
                    TableDescriptor tableDescriptor = admin.getDescriptor(PermissionStorage.ACL_TABLE_NAME);
                    boolean containHdfsAclFamily = Arrays.stream(tableDescriptor.getColumnFamilies()).anyMatch(family -> Bytes.equals((byte[])family.getName(), (byte[])SnapshotScannerHDFSAclStorage.HDFS_ACL_FAMILY));
                    if (!containHdfsAclFamily) {
                        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])SnapshotScannerHDFSAclStorage.HDFS_ACL_FAMILY).build());
                        admin.modifyTable(builder.build());
                    }
                    this.aclTableInitialized = true;
                    break block15;
                }
                throw new TableNotFoundException("Table " + PermissionStorage.ACL_TABLE_NAME + " is not created yet. Please check if " + this.getClass().getName() + " is configured after " + AccessController.class.getName());
            }
        }
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) {
        if (this.initialized) {
            this.hdfsAclHelper.close();
        }
    }

    @Override
    public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (this.needHandleTableHdfsAcl(desc, "createTable " + desc.getTableName())) {
            TableName tableName = desc.getTableName();
            this.hdfsAclHelper.createTableDirectories(tableName);
            String owner = desc.getOwnerString() == null ? this.getActiveUser(c).getShortName() : desc.getOwnerString();
            this.hdfsAclHelper.addTableAcl(tableName, Sets.newHashSet((Object[])new String[]{owner}), "create");
            SnapshotScannerHDFSAclStorage.addUserTableHdfsAcl(c.getEnvironment().getConnection(), owner, tableName);
        }
    }

    @Override
    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> c, NamespaceDescriptor ns) throws IOException {
        if (this.checkInitialized("createNamespace " + ns.getName())) {
            List<Path> paths = this.hdfsAclHelper.getNamespaceRootPaths(ns.getName());
            for (Path path : paths) {
                this.hdfsAclHelper.createDirIfNotExist(path);
            }
        }
    }

    @Override
    public void postCompletedSnapshotAction(ObserverContext<MasterCoprocessorEnvironment> c, SnapshotDescription snapshot, TableDescriptor tableDescriptor) throws IOException {
        if (this.needHandleTableHdfsAcl(tableDescriptor, "snapshot " + snapshot.getName())) {
            this.hdfsAclHelper.snapshotAcl(snapshot);
        }
    }

    @Override
    public void postCompletedTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (this.needHandleTableHdfsAcl(tableName, "truncateTable " + tableName)) {
            this.hdfsAclHelper.createTableDirectories(tableName);
            Set<String> users = this.hdfsAclHelper.getUsersWithTableReadAction(tableName, false, false);
            this.hdfsAclHelper.addTableAcl(tableName, users, "truncate");
        }
    }

    @Override
    public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!tableName.isSystemTable() && this.checkInitialized("deleteTable " + tableName)) {
            try (Table aclTable = ctx.getEnvironment().getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                Set<String> users = SnapshotScannerHDFSAclStorage.getTableUsers(aclTable, tableName);
                if (users.size() > 0) {
                    this.hdfsAclHelper.removeTableDefaultAcl(tableName, users);
                    SnapshotScannerHDFSAclStorage.deleteTableHdfsAcl(aclTable, tableName);
                    Set<String> removeUsers = this.filterUsersToRemoveNsAccessAcl(aclTable, tableName, users);
                    if (removeUsers.size() > 0) {
                        this.hdfsAclHelper.removeNamespaceAccessAcl(tableName, removeUsers, "delete");
                    }
                }
            }
        }
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor oldDescriptor, TableDescriptor currentDescriptor) throws IOException {
        try (Table aclTable = ctx.getEnvironment().getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
            if (this.needHandleTableHdfsAcl(currentDescriptor, "modifyTable " + tableName) && !this.hdfsAclHelper.isAclSyncToHdfsEnabled(oldDescriptor)) {
                this.hdfsAclHelper.createTableDirectories(tableName);
                Set<String> tableUsers = this.hdfsAclHelper.getUsersWithTableReadAction(tableName, false, false);
                Set<String> users = this.hdfsAclHelper.getUsersWithNamespaceReadAction(tableName.getNamespaceAsString(), true);
                users.addAll(tableUsers);
                this.hdfsAclHelper.addTableAcl(tableName, users, "modify");
                SnapshotScannerHDFSAclStorage.addUserTableHdfsAcl(ctx.getEnvironment().getConnection(), tableUsers, tableName);
            } else if (this.needHandleTableHdfsAcl(oldDescriptor, "modifyTable " + tableName) && !this.hdfsAclHelper.isAclSyncToHdfsEnabled(currentDescriptor)) {
                List<Path> tableRootPaths = this.hdfsAclHelper.getTableRootPaths(tableName, false);
                for (Path path : tableRootPaths) {
                    this.hdfsAclHelper.deleteEmptyDir(path);
                }
                Set<String> tableUsers = this.hdfsAclHelper.getUsersWithTableReadAction(tableName, false, false);
                Set<String> users = this.hdfsAclHelper.getUsersWithNamespaceReadAction(tableName.getNamespaceAsString(), true);
                users.addAll(tableUsers);
                this.hdfsAclHelper.removeTableAcl(tableName, users);
                this.hdfsAclHelper.removeNamespaceAccessAcl(tableName, this.filterUsersToRemoveNsAccessAcl(aclTable, tableName, tableUsers), "modify");
                SnapshotScannerHDFSAclStorage.deleteUserTableHdfsAcl(ctx.getEnvironment().getConnection(), tableUsers, tableName);
            }
        }
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (this.checkInitialized("deleteNamespace " + namespace)) {
            try (Table aclTable = ctx.getEnvironment().getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                Set users = SnapshotScannerHDFSAclStorage.getEntryUsers(aclTable, PermissionStorage.toNamespaceEntry(Bytes.toBytes((String)namespace)));
                this.hdfsAclHelper.removeNamespaceDefaultAcl(namespace, users);
                SnapshotScannerHDFSAclStorage.deleteNamespaceHdfsAcl(ctx.getEnvironment().getConnection(), namespace);
                this.hdfsAclHelper.deleteEmptyDir(this.pathHelper.getTmpNsDir(namespace));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postGrant(ObserverContext<MasterCoprocessorEnvironment> c, UserPermission userPermission, boolean mergeExistingPermissions) throws IOException {
        if (!this.checkInitialized("grant " + userPermission + ", merge existing permissions " + mergeExistingPermissions)) {
            return;
        }
        try (Table aclTable = c.getEnvironment().getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
            Configuration conf = c.getEnvironment().getConfiguration();
            String userName = userPermission.getUser();
            switch (userPermission.getAccessScope()) {
                case GLOBAL: {
                    UserPermission perm = this.getUserGlobalPermission(conf, userName);
                    if (perm != null && this.hdfsAclHelper.containReadAction(perm)) {
                        if (this.isHdfsAclSet(aclTable, userName)) return;
                        Pair<Set<String>, Set<TableName>> skipNamespaceAndTables = SnapshotScannerHDFSAclStorage.getUserNamespaceAndTable(aclTable, userName);
                        Set skipNamespaces = (Set)skipNamespaceAndTables.getFirst();
                        Set<TableName> skipTables = ((Set)skipNamespaceAndTables.getSecond()).stream().filter(t -> !skipNamespaces.contains(t.getNamespaceAsString())).collect(Collectors.toSet());
                        this.hdfsAclHelper.grantAcl(userPermission, skipNamespaces, skipTables);
                        SnapshotScannerHDFSAclStorage.addUserGlobalHdfsAcl(aclTable, userName);
                        return;
                    } else {
                        this.removeUserGlobalHdfsAcl(aclTable, userName, userPermission);
                        return;
                    }
                }
                case NAMESPACE: {
                    String namespace = ((NamespacePermission)userPermission.getPermission()).getNamespace();
                    UserPermission nsPerm = this.getUserNamespacePermission(conf, userName, namespace);
                    if (nsPerm != null && this.hdfsAclHelper.containReadAction(nsPerm)) {
                        if (!this.isHdfsAclSet(aclTable, userName, namespace)) {
                            Set skipTables = (Set)SnapshotScannerHDFSAclStorage.getUserNamespaceAndTable(aclTable, userName).getSecond();
                            this.hdfsAclHelper.grantAcl(userPermission, new HashSet<String>(0), skipTables);
                        }
                        SnapshotScannerHDFSAclStorage.addUserNamespaceHdfsAcl(aclTable, userName, namespace);
                        return;
                    } else {
                        this.removeUserNamespaceHdfsAcl(aclTable, userName, namespace, userPermission);
                        return;
                    }
                }
                case TABLE: {
                    TablePermission tablePerm = (TablePermission)userPermission.getPermission();
                    if (!this.needHandleTableHdfsAcl(tablePerm)) return;
                    TableName tableName = tablePerm.getTableName();
                    UserPermission tPerm = this.getUserTablePermission(conf, userName, tableName);
                    if (tPerm != null && this.hdfsAclHelper.containReadAction(tPerm)) {
                        if (!this.isHdfsAclSet(aclTable, userName, tableName)) {
                            this.hdfsAclHelper.createTableDirectories(tableName);
                            this.hdfsAclHelper.grantAcl(userPermission, new HashSet<String>(0), new HashSet<TableName>(0));
                        }
                        SnapshotScannerHDFSAclStorage.addUserTableHdfsAcl(aclTable, userName, tableName);
                        return;
                    } else {
                        this.removeUserTableHdfsAcl(aclTable, userName, tableName, userPermission);
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Illegal user permission scope " + userPermission.getAccessScope());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postRevoke(ObserverContext<MasterCoprocessorEnvironment> c, UserPermission userPermission) throws IOException {
        if (!this.checkInitialized("revoke " + userPermission)) return;
        try (Table aclTable = c.getEnvironment().getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
            String userName = userPermission.getUser();
            Configuration conf = c.getEnvironment().getConfiguration();
            switch (userPermission.getAccessScope()) {
                case GLOBAL: {
                    UserPermission userGlobalPerm = this.getUserGlobalPermission(conf, userName);
                    if (userGlobalPerm != null && this.hdfsAclHelper.containReadAction(userGlobalPerm)) return;
                    this.removeUserGlobalHdfsAcl(aclTable, userName, userPermission);
                    return;
                }
                case NAMESPACE: {
                    NamespacePermission nsPerm = (NamespacePermission)userPermission.getPermission();
                    UserPermission userNsPerm = this.getUserNamespacePermission(conf, userName, nsPerm.getNamespace());
                    if (userNsPerm != null && this.hdfsAclHelper.containReadAction(userNsPerm)) return;
                    this.removeUserNamespaceHdfsAcl(aclTable, userName, nsPerm.getNamespace(), userPermission);
                    return;
                }
                case TABLE: {
                    TableName tableName;
                    UserPermission userTablePerm;
                    TablePermission tPerm = (TablePermission)userPermission.getPermission();
                    if (!this.needHandleTableHdfsAcl(tPerm) || (userTablePerm = this.getUserTablePermission(conf, userName, tableName = tPerm.getTableName())) != null && this.hdfsAclHelper.containReadAction(userTablePerm)) return;
                    this.removeUserTableHdfsAcl(aclTable, userName, tableName, userPermission);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Illegal user permission scope " + userPermission.getAccessScope());
                }
            }
        }
    }

    private void removeUserGlobalHdfsAcl(Table aclTable, String userName, UserPermission userPermission) throws IOException {
        if (SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl(aclTable, userName)) {
            Pair<Set<String>, Set<TableName>> namespaceAndTable = SnapshotScannerHDFSAclStorage.getUserNamespaceAndTable(aclTable, userName);
            Set skipNamespaces = (Set)namespaceAndTable.getFirst();
            Set<TableName> skipTables = ((Set)namespaceAndTable.getSecond()).stream().filter(t -> !skipNamespaces.contains(t.getNamespaceAsString())).collect(Collectors.toSet());
            this.hdfsAclHelper.revokeAcl(userPermission, skipNamespaces, skipTables);
            SnapshotScannerHDFSAclStorage.deleteUserGlobalHdfsAcl(aclTable, userName);
        }
    }

    private void removeUserNamespaceHdfsAcl(Table aclTable, String userName, String namespace, UserPermission userPermission) throws IOException {
        if (SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl(aclTable, userName, namespace)) {
            if (!SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl(aclTable, userName)) {
                Set skipTables = (Set)SnapshotScannerHDFSAclStorage.getUserNamespaceAndTable(aclTable, userName).getSecond();
                this.hdfsAclHelper.revokeAcl(userPermission, new HashSet<String>(), skipTables);
            }
            SnapshotScannerHDFSAclStorage.deleteUserNamespaceHdfsAcl(aclTable, userName, namespace);
        }
    }

    private void removeUserTableHdfsAcl(Table aclTable, String userName, TableName tableName, UserPermission userPermission) throws IOException {
        if (SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl(aclTable, userName, tableName)) {
            if (!SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl(aclTable, userName) && !SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl(aclTable, userName, tableName.getNamespaceAsString())) {
                this.hdfsAclHelper.revokeAcl(userPermission, new HashSet<String>(0), new HashSet<TableName>(0));
            }
            SnapshotScannerHDFSAclStorage.deleteUserTableHdfsAcl(aclTable, userName, tableName);
        }
    }

    private UserPermission getUserGlobalPermission(Configuration conf, String userName) throws IOException {
        List<UserPermission> permissions = PermissionStorage.getUserPermissions(conf, PermissionStorage.ACL_GLOBAL_NAME, null, null, userName, true);
        return permissions.size() > 0 ? permissions.get(0) : null;
    }

    private UserPermission getUserNamespacePermission(Configuration conf, String userName, String namespace) throws IOException {
        List<UserPermission> permissions = PermissionStorage.getUserNamespacePermissions(conf, namespace, userName, true);
        return permissions.size() > 0 ? permissions.get(0) : null;
    }

    private UserPermission getUserTablePermission(Configuration conf, String userName, TableName tableName) throws IOException {
        List permissions = PermissionStorage.getUserTablePermissions(conf, tableName, null, null, userName, true).stream().filter(userPermission -> this.hdfsAclHelper.isNotFamilyOrQualifierPermission((TablePermission)userPermission.getPermission())).collect(Collectors.toList());
        return permissions.size() > 0 ? (UserPermission)permissions.get(0) : null;
    }

    private boolean isHdfsAclSet(Table aclTable, String userName) throws IOException {
        return this.isHdfsAclSet(aclTable, userName, null, null);
    }

    private boolean isHdfsAclSet(Table aclTable, String userName, String namespace) throws IOException {
        return this.isHdfsAclSet(aclTable, userName, namespace, null);
    }

    private boolean isHdfsAclSet(Table aclTable, String userName, TableName tableName) throws IOException {
        return this.isHdfsAclSet(aclTable, userName, null, tableName);
    }

    private boolean isHdfsAclSet(Table aclTable, String userName, String namespace, TableName tableName) throws IOException {
        boolean isSet = SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl(aclTable, userName);
        if (namespace != null) {
            boolean bl = isSet = isSet || SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl(aclTable, userName, namespace);
        }
        if (tableName != null) {
            isSet = isSet || SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl(aclTable, userName, tableName.getNamespaceAsString()) || SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl(aclTable, userName, tableName);
        }
        return isSet;
    }

    @InterfaceAudience.Private
    boolean checkInitialized(String operation) {
        if (this.initialized) {
            if (this.aclTableInitialized) {
                return true;
            }
            LOG.warn("Skip set HDFS acls because acl table is not initialized when {}", (Object)operation);
        }
        return false;
    }

    private boolean needHandleTableHdfsAcl(TablePermission tablePermission) throws IOException {
        return this.needHandleTableHdfsAcl(tablePermission.getTableName(), "") && this.hdfsAclHelper.isNotFamilyOrQualifierPermission(tablePermission);
    }

    private boolean needHandleTableHdfsAcl(TableName tableName, String operation) throws IOException {
        return !tableName.isSystemTable() && this.checkInitialized(operation) && this.hdfsAclHelper.isAclSyncToHdfsEnabled(this.masterServices.getTableDescriptors().get(tableName));
    }

    private boolean needHandleTableHdfsAcl(TableDescriptor tableDescriptor, String operation) {
        TableName tableName = tableDescriptor.getTableName();
        return !tableName.isSystemTable() && this.checkInitialized(operation) && this.hdfsAclHelper.isAclSyncToHdfsEnabled(tableDescriptor);
    }

    private User getActiveUser(ObserverContext<?> ctx) throws IOException {
        Optional<User> optionalUser = ctx.getCaller();
        if (optionalUser.isPresent()) {
            return optionalUser.get();
        }
        return this.userProvider.getCurrent();
    }

    private Set<String> filterUsersToRemoveNsAccessAcl(Table aclTable, TableName tableName, Set<String> tablesUsers) throws IOException {
        HashSet<String> removeUsers = new HashSet<String>();
        byte[] namespace = tableName.getNamespace();
        for (String user : tablesUsers) {
            List<byte[]> userEntries = SnapshotScannerHDFSAclStorage.getUserEntries(aclTable, user);
            boolean remove = true;
            for (byte[] entry : userEntries) {
                if (!PermissionStorage.isGlobalEntry(entry) && (!PermissionStorage.isNamespaceEntry(entry) || !Bytes.equals((byte[])PermissionStorage.fromNamespaceEntry(entry), (byte[])namespace)) && (!PermissionStorage.isTableEntry(entry) || Bytes.equals((byte[])tableName.getName(), (byte[])entry) || !Bytes.equals((byte[])TableName.valueOf((byte[])entry).getNamespace(), (byte[])namespace))) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            removeUsers.add(user);
        }
        return removeUsers;
    }

    static final class SnapshotScannerHDFSAclStorage {
        static final byte[] HDFS_ACL_FAMILY = Bytes.toBytes((String)"m");
        private static final byte[] HDFS_ACL_VALUE = Bytes.toBytes((String)"R");

        SnapshotScannerHDFSAclStorage() {
        }

        static void addUserGlobalHdfsAcl(Table aclTable, String user) throws IOException {
            SnapshotScannerHDFSAclStorage.addUserEntry(aclTable, user, PermissionStorage.ACL_GLOBAL_NAME);
        }

        static void addUserNamespaceHdfsAcl(Table aclTable, String user, String namespace) throws IOException {
            SnapshotScannerHDFSAclStorage.addUserEntry(aclTable, user, Bytes.toBytes((String)PermissionStorage.toNamespaceEntry(namespace)));
        }

        static void addUserTableHdfsAcl(Connection connection, Set<String> users, TableName tableName) throws IOException {
            try (Table aclTable = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
                for (String user : users) {
                    SnapshotScannerHDFSAclStorage.addUserTableHdfsAcl(aclTable, user, tableName);
                }
            }
        }

        static void addUserTableHdfsAcl(Connection connection, String user, TableName tableName) throws IOException {
            try (Table aclTable = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
                SnapshotScannerHDFSAclStorage.addUserTableHdfsAcl(aclTable, user, tableName);
            }
        }

        static void addUserTableHdfsAcl(Table aclTable, String user, TableName tableName) throws IOException {
            SnapshotScannerHDFSAclStorage.addUserEntry(aclTable, user, tableName.getName());
        }

        private static void addUserEntry(Table t, String user, byte[] entry) throws IOException {
            Put p = new Put(entry);
            p.addColumn(HDFS_ACL_FAMILY, Bytes.toBytes((String)user), HDFS_ACL_VALUE);
            t.put(p);
        }

        static void deleteUserGlobalHdfsAcl(Table aclTable, String user) throws IOException {
            SnapshotScannerHDFSAclStorage.deleteUserEntry(aclTable, user, PermissionStorage.ACL_GLOBAL_NAME);
        }

        static void deleteUserNamespaceHdfsAcl(Table aclTable, String user, String namespace) throws IOException {
            SnapshotScannerHDFSAclStorage.deleteUserEntry(aclTable, user, Bytes.toBytes((String)PermissionStorage.toNamespaceEntry(namespace)));
        }

        static void deleteUserTableHdfsAcl(Table aclTable, String user, TableName tableName) throws IOException {
            SnapshotScannerHDFSAclStorage.deleteUserEntry(aclTable, user, tableName.getName());
        }

        static void deleteUserTableHdfsAcl(Connection connection, Set<String> users, TableName tableName) throws IOException {
            try (Table aclTable = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
                for (String user : users) {
                    SnapshotScannerHDFSAclStorage.deleteUserTableHdfsAcl(aclTable, user, tableName);
                }
            }
        }

        private static void deleteUserEntry(Table aclTable, String user, byte[] entry) throws IOException {
            Delete delete = new Delete(entry);
            delete.addColumns(HDFS_ACL_FAMILY, Bytes.toBytes((String)user));
            aclTable.delete(delete);
        }

        static void deleteNamespaceHdfsAcl(Connection connection, String namespace) throws IOException {
            try (Table aclTable = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
                SnapshotScannerHDFSAclStorage.deleteEntry(aclTable, Bytes.toBytes((String)PermissionStorage.toNamespaceEntry(namespace)));
            }
        }

        static void deleteTableHdfsAcl(Table aclTable, TableName tableName) throws IOException {
            SnapshotScannerHDFSAclStorage.deleteEntry(aclTable, tableName.getName());
        }

        private static void deleteEntry(Table aclTable, byte[] entry) throws IOException {
            Delete delete = new Delete(entry);
            delete.addFamily(HDFS_ACL_FAMILY);
            aclTable.delete(delete);
        }

        static Set<String> getTableUsers(Table aclTable, TableName tableName) throws IOException {
            return SnapshotScannerHDFSAclStorage.getEntryUsers(aclTable, tableName.getName());
        }

        private static Set<String> getEntryUsers(Table aclTable, byte[] entry) throws IOException {
            HashSet<String> users = new HashSet<String>();
            Get get = new Get(entry);
            get.addFamily(HDFS_ACL_FAMILY);
            Result result = aclTable.get(get);
            List cells = result.listCells();
            if (cells != null) {
                for (Cell cell : cells) {
                    if (cell == null) continue;
                    users.add(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)));
                }
            }
            return users;
        }

        static Pair<Set<String>, Set<TableName>> getUserNamespaceAndTable(Table aclTable, String userName) throws IOException {
            HashSet<String> namespaces = new HashSet<String>();
            HashSet<TableName> tables = new HashSet<TableName>();
            List<byte[]> userEntries = SnapshotScannerHDFSAclStorage.getUserEntries(aclTable, userName);
            for (byte[] entry : userEntries) {
                if (PermissionStorage.isNamespaceEntry(entry)) {
                    namespaces.add(Bytes.toString((byte[])PermissionStorage.fromNamespaceEntry(entry)));
                    continue;
                }
                if (!PermissionStorage.isTableEntry(entry)) continue;
                tables.add(TableName.valueOf((byte[])entry));
            }
            return new Pair(namespaces, tables);
        }

        static List<byte[]> getUserEntries(Table aclTable, String userName) throws IOException {
            Scan scan = new Scan();
            scan.addColumn(HDFS_ACL_FAMILY, Bytes.toBytes((String)userName));
            ResultScanner scanner = aclTable.getScanner(scan);
            ArrayList<byte[]> entry = new ArrayList<byte[]>();
            for (Result result : scanner) {
                if (result == null || result.getRow() == null) continue;
                entry.add(result.getRow());
            }
            return entry;
        }

        static boolean hasUserGlobalHdfsAcl(Table aclTable, String user) throws IOException {
            return SnapshotScannerHDFSAclStorage.hasUserEntry(aclTable, user, PermissionStorage.ACL_GLOBAL_NAME);
        }

        static boolean hasUserNamespaceHdfsAcl(Table aclTable, String user, String namespace) throws IOException {
            return SnapshotScannerHDFSAclStorage.hasUserEntry(aclTable, user, Bytes.toBytes((String)PermissionStorage.toNamespaceEntry(namespace)));
        }

        static boolean hasUserTableHdfsAcl(Table aclTable, String user, TableName tableName) throws IOException {
            return SnapshotScannerHDFSAclStorage.hasUserEntry(aclTable, user, tableName.getName());
        }

        private static boolean hasUserEntry(Table aclTable, String userName, byte[] entry) throws IOException {
            Get get = new Get(entry);
            get.addColumn(HDFS_ACL_FAMILY, Bytes.toBytes((String)userName));
            return aclTable.exists(get);
        }
    }
}

