/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.procedure2.DelayedProcedure;
import org.apache.hadoop.hbase.procedure2.InlineChore;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureInMemoryChore;
import org.apache.hadoop.hbase.procedure2.RootProcedureState;
import org.apache.hadoop.hbase.procedure2.StoppableThread;
import org.apache.hadoop.hbase.procedure2.util.DelayedUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class TimeoutExecutorThread<TEnvironment>
extends StoppableThread {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutExecutorThread.class);
    private final ProcedureExecutor<TEnvironment> executor;
    private final DelayQueue<DelayedUtil.DelayedWithTimeout> queue = new DelayQueue();

    public TimeoutExecutorThread(ProcedureExecutor<TEnvironment> executor, ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
        this.executor = executor;
    }

    @Override
    public void sendStopSignal() {
        this.queue.add(DelayedUtil.DELAYED_POISON);
    }

    @Override
    public void run() {
        while (this.executor.isRunning()) {
            DelayedUtil.DelayedWithTimeout task = DelayedUtil.takeWithoutInterrupt(this.queue, 20L, TimeUnit.SECONDS);
            if (task == null || task == DelayedUtil.DELAYED_POISON) continue;
            LOG.trace("Executing {}", (Object)task);
            if (task instanceof InlineChore) {
                this.execInlineChore((InlineChore)task);
                continue;
            }
            if (task instanceof DelayedProcedure) {
                this.execDelayedProcedure((DelayedProcedure)task);
                continue;
            }
            LOG.error("CODE-BUG unknown timeout task type {}", (Object)task);
        }
    }

    public void add(InlineChore chore) {
        chore.refreshTimeout();
        this.queue.add(chore);
    }

    public void add(Procedure<TEnvironment> procedure) {
        LOG.info("ADDED {}; timeout={}, timestamp={}", new Object[]{procedure, procedure.getTimeout(), procedure.getTimeoutTimestamp()});
        this.queue.add(new DelayedProcedure<TEnvironment>(procedure));
    }

    public boolean remove(Procedure<TEnvironment> procedure) {
        return this.queue.remove(new DelayedProcedure<TEnvironment>(procedure));
    }

    private void execInlineChore(InlineChore chore) {
        chore.run();
        this.add(chore);
    }

    private void execDelayedProcedure(DelayedProcedure<TEnvironment> delayed) {
        Procedure procedure = (Procedure)delayed.getObject();
        if (procedure instanceof ProcedureInMemoryChore) {
            this.executeInMemoryChore((ProcedureInMemoryChore)procedure);
            procedure.updateTimestamp();
            if (procedure.isWaiting()) {
                delayed.setTimeout(procedure.getTimeoutTimestamp());
                this.queue.add(delayed);
            }
        } else {
            this.executeTimedoutProcedure(procedure);
        }
    }

    private void executeInMemoryChore(ProcedureInMemoryChore<TEnvironment> chore) {
        if (!chore.isWaiting()) {
            return;
        }
        try {
            chore.periodicExecute(this.executor.getEnvironment());
        }
        catch (Throwable e) {
            LOG.error("Ignoring {} exception: {}", new Object[]{chore, e.getMessage(), e});
        }
    }

    protected void executeTimedoutProcedure(Procedure<TEnvironment> proc) {
        if (proc.setTimeoutFailure(this.executor.getEnvironment())) {
            long rootProcId = this.executor.getRootProcedureId(proc);
            RootProcedureState<TEnvironment> procStack = this.executor.getProcStack(rootProcId);
            procStack.abort();
            this.executor.getStore().update(proc);
            this.executor.getScheduler().addFront(proc);
        }
    }
}

