/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class SequentialProcedure<TEnvironment>
extends Procedure<TEnvironment> {
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure[] doExecute(TEnvironment env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        this.updateTimestamp();
        try {
            Procedure[] children = !this.executed ? this.execute(env) : null;
            this.executed = !this.executed;
            Procedure[] procedureArray = children;
            return procedureArray;
        }
        finally {
            this.updateTimestamp();
        }
    }

    @Override
    protected void doRollback(TEnvironment env) throws IOException, InterruptedException {
        this.updateTimestamp();
        if (this.executed) {
            try {
                this.rollback(env);
                this.executed = !this.executed;
            }
            finally {
                this.updateTimestamp();
            }
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        ProcedureProtos.SequentialProcedureData.Builder data = ProcedureProtos.SequentialProcedureData.newBuilder();
        data.setExecuted(this.executed);
        serializer.serialize((Message)data.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        ProcedureProtos.SequentialProcedureData data = serializer.deserialize(ProcedureProtos.SequentialProcedureData.class);
        this.executed = data.getExecuted();
    }
}

