/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HtmlQuoting;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHtmlQuoting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHtmlQuoting.class);

    @Test
    public void testNeedsQuoting() throws Exception {
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde>"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"<abcde"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abc'de"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde\""));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"&"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting((String)""));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting((String)"ab\ncdef"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting(null));
    }

    @Test
    public void testQuoting() throws Exception {
        Assert.assertEquals((Object)"ab&lt;cd", (Object)HtmlQuoting.quoteHtmlChars((String)"ab<cd"));
        Assert.assertEquals((Object)"ab&gt;", (Object)HtmlQuoting.quoteHtmlChars((String)"ab>"));
        Assert.assertEquals((Object)"&amp;&amp;&amp;", (Object)HtmlQuoting.quoteHtmlChars((String)"&&&"));
        Assert.assertEquals((Object)" &apos;\n", (Object)HtmlQuoting.quoteHtmlChars((String)" '\n"));
        Assert.assertEquals((Object)"&quot;", (Object)HtmlQuoting.quoteHtmlChars((String)"\""));
        Assert.assertEquals(null, (Object)HtmlQuoting.quoteHtmlChars(null));
    }

    private void runRoundTrip(String str) throws Exception {
        Assert.assertEquals((Object)str, (Object)HtmlQuoting.unquoteHtmlChars((String)HtmlQuoting.quoteHtmlChars((String)str)));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.runRoundTrip("");
        this.runRoundTrip("<>&'\"");
        this.runRoundTrip("ab>cd<ef&ghi'\"");
        this.runRoundTrip("A string\n with no quotable chars in it!");
        this.runRoundTrip(null);
        StringBuilder buffer = new StringBuilder();
        for (char ch = '\u0000'; ch < '\u007f'; ch = (char)(ch + '\u0001')) {
            buffer.append(ch);
        }
        this.runRoundTrip(buffer.toString());
    }

    @Test
    public void testRequestQuoting() throws Exception {
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServer.QuotingInputFilter.RequestQuoter quoter = new HttpServer.QuotingInputFilter.RequestQuoter(mockReq);
        ((HttpServletRequest)Mockito.doReturn((Object)"a<b").when((Object)mockReq)).getParameter("x");
        Assert.assertEquals((String)"Test simple param quoting", (Object)"a&lt;b", (Object)quoter.getParameter("x"));
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameter("x");
        Assert.assertEquals((String)"Test that missing parameters dont cause NPE", null, (Object)quoter.getParameter("x"));
        ((HttpServletRequest)Mockito.doReturn((Object)new String[]{"a<b", "b"}).when((Object)mockReq)).getParameterValues("x");
        Assert.assertArrayEquals((String)"Test escaping of an array", (Object[])new String[]{"a&lt;b", "b"}, (Object[])quoter.getParameterValues("x"));
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameterValues("x");
        Assert.assertNull((String)"Test that missing parameters dont cause NPE for array", (Object)quoter.getParameterValues("x"));
    }
}

