/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.FilterContainer;
import org.apache.hadoop.hbase.http.FilterInitializer;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestGlobalFilter
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGlobalFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private static final Set<String> RECORDS = new TreeSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletFilter() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.http.filter.initializers", RecordingFilter.Initializer.class.getName());
        HttpServer http = TestGlobalFilter.createTestServer(conf);
        http.start();
        String fsckURL = "/fsck";
        String stacksURL = "/stacks";
        String ajspURL = "/a.jsp";
        String listPathsURL = "/listPaths";
        String dataURL = "/data";
        String streamFile = "/streamFile";
        String rootURL = "/";
        String allURL = "/*";
        String outURL = "/static/a.out";
        String logURL = "/logs/a.log";
        String[] urls = new String[]{"/fsck", "/stacks", "/a.jsp", "/listPaths", "/data", "/streamFile", "/", "/*", "/static/a.out", "/logs/a.log"};
        String prefix = "http://" + NetUtils.getHostPortString((InetSocketAddress)http.getConnectorAddress(0));
        try {
            for (String url : urls) {
                TestGlobalFilter.access(prefix + url);
            }
        }
        finally {
            http.stop();
        }
        LOG.info("RECORDS = " + RECORDS);
        for (String url : urls) {
            Assert.assertTrue((boolean)RECORDS.remove(url));
        }
        Assert.assertTrue((boolean)RECORDS.isEmpty());
    }

    public static class RecordingFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            String uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info("filtering " + uri);
            RECORDS.add(uri);
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addGlobalFilter("recording", RecordingFilter.class.getName(), null);
            }
        }
    }
}

