/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore(value="Hangs on occasion; see HBASE-14430")
@Category(value={MiscTests.class, SmallTests.class})
public class TestHttpServerLifecycle
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHttpServerLifecycle.class);

    private void assertAlive(HttpServer server) {
        Assert.assertTrue((String)"Server is not alive", (boolean)server.isAlive());
        this.assertToStringContains(server, " - alive");
    }

    private void assertNotLive(HttpServer server) {
        Assert.assertTrue((String)"Server should not be live", (!server.isAlive() ? 1 : 0) != 0);
        this.assertToStringContains(server, " - not live");
    }

    @Test
    public void testCreatedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
    }

    @Test
    public void testStopUnstartedServer() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        TestHttpServerLifecycle.stop(server);
    }

    @Test
    public void testStartedServerIsAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
    }

    private void assertToStringContains(HttpServer server, String text) {
        String description = server.toString();
        Assert.assertTrue((String)("Did not find \"" + text + "\" in \"" + description + "\""), (boolean)description.contains(text));
    }

    @Test
    public void testStoppedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Test
    public void testStoppingTwiceServerIsAllowed() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Test
    public void testWepAppContextAfterServerStop() throws Throwable {
        String key = "test.attribute.key";
        String value = "test.attribute.value";
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        server.setAttribute(key, (Object)value);
        this.assertAlive(server);
        Assert.assertEquals((Object)value, (Object)server.getAttribute(key));
        TestHttpServerLifecycle.stop(server);
        Assert.assertNull((String)"Server context should have cleared", (Object)server.getAttribute(key));
    }
}

