/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsThriftServerSourceImpl
extends BaseSourceImpl
implements MetricsThriftServerSource {
    private MutableHistogram batchGetStat;
    private MutableHistogram batchMutateStat;
    private MutableHistogram queueTimeStat;
    private MutableHistogram thriftCallStat;
    private MutableHistogram thriftSlowCallStat;
    private MutableGaugeLong callQueueLenGauge;

    public MetricsThriftServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.batchGetStat = this.getMetricsRegistry().newTimeHistogram("batchGet");
        this.batchMutateStat = this.getMetricsRegistry().newTimeHistogram("batchMutate");
        this.queueTimeStat = this.getMetricsRegistry().newTimeHistogram("timeInQueue");
        this.thriftCallStat = this.getMetricsRegistry().newTimeHistogram("thriftCall");
        this.thriftSlowCallStat = this.getMetricsRegistry().newTimeHistogram("slowThriftCall");
        this.callQueueLenGauge = this.getMetricsRegistry().getLongGauge("callQueueLen", 0L);
    }

    public void incTimeInQueue(long time) {
        this.queueTimeStat.add(time);
    }

    public void setCallQueueLen(int len) {
        this.callQueueLenGauge.set((long)len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.batchGetStat.add(diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.batchMutateStat.add(diff);
    }

    public void incMethodTime(String name, long time) {
        MutableHistogram s = this.getMetricsRegistry().getHistogram(name);
        s.add(time);
    }

    public void incCall(long time) {
        this.thriftCallStat.add(time);
    }

    public void incSlowCall(long time) {
        this.thriftSlowCallStat.add(time);
    }
}

