/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider.example;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.example.ShadeSaslAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ShadeSaslClientAuthenticationProvider
extends ShadeSaslAuthenticationProvider
implements SaslClientAuthenticationProvider {
    public SaslClient createClient(Configuration conf, InetAddress serverAddr, String serverPrincipal, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
        return Sasl.createSaslClient(new String[]{this.getSaslAuthMethod().getSaslMechanism()}, null, null, "default", saslProps, new ShadeSaslClientCallbackHandler(token));
    }

    public RPCProtos.UserInformation getUserInfo(User user) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(user.getUGI().getUserName());
        return userInfoPB.build();
    }

    public boolean canRetry() {
        return false;
    }

    static class ShadeSaslClientCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final char[] password;

        public ShadeSaslClientCallbackHandler(Token<? extends TokenIdentifier> token) throws IOException {
            TokenIdentifier id = token.decodeIdentifier();
            if (id == null) {
                throw new IllegalStateException("Could not extract Identifier from Token");
            }
            this.username = id.getUser().getUserName();
            this.password = Bytes.toString((byte[])token.getPassword()).toCharArray();
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                nc.setName(this.username);
            }
            if (pc != null) {
                pc.setPassword(this.password);
            }
            if (rc != null) {
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

