/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import com.github.luben.zstd.ZstdDecompressCtx;
import com.github.luben.zstd.ZstdDictDecompress;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.compress.BlockDecompressorHelper;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdHFileDecompressionContext;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZstdByteBuffDecompressor
implements ByteBuffDecompressor {
    protected int dictId;
    protected ZstdDecompressCtx ctx = new ZstdDecompressCtx();
    private boolean allowByteBuffDecompression;

    ZstdByteBuffDecompressor(@Nullable byte[] dictionaryBytes) {
        if (dictionaryBytes != null) {
            this.ctx.loadDict(new ZstdDictDecompress(dictionaryBytes));
            this.dictId = ZstdCodec.getDictionaryId(dictionaryBytes);
        }
        this.allowByteBuffDecompression = true;
    }

    public boolean canDecompress(ByteBuff output, ByteBuff input) {
        return this.allowByteBuffDecompression && output instanceof SingleByteBuff && input instanceof SingleByteBuff;
    }

    public int decompress(ByteBuff output, ByteBuff input, int inputLen) throws IOException {
        return BlockDecompressorHelper.decompress((ByteBuff)output, (ByteBuff)input, (int)inputLen, this::decompressRaw);
    }

    private int decompressRaw(ByteBuff output, ByteBuff input, int inputLen) throws IOException {
        if (output instanceof SingleByteBuff && input instanceof SingleByteBuff) {
            int n;
            ByteBuffer nioOutput = output.nioByteBuffers()[0];
            ByteBuffer nioInput = input.nioByteBuffers()[0];
            int origOutputPos = nioOutput.position();
            if (nioOutput.isDirect() && nioInput.isDirect()) {
                n = this.ctx.decompressDirectByteBuffer(nioOutput, nioOutput.position(), nioOutput.limit() - nioOutput.position(), nioInput, nioInput.position(), inputLen);
            } else if (!nioOutput.isDirect() && !nioInput.isDirect()) {
                n = this.ctx.decompressByteArray(nioOutput.array(), nioOutput.arrayOffset() + nioOutput.position(), nioOutput.limit() - nioOutput.position(), nioInput.array(), nioInput.arrayOffset() + nioInput.position(), inputLen);
            } else if (nioOutput.isDirect() && !nioInput.isDirect()) {
                n = this.ctx.decompressByteArrayToDirectByteBuffer(nioOutput, nioOutput.position(), nioOutput.limit() - nioOutput.position(), nioInput.array(), nioInput.arrayOffset() + nioInput.position(), inputLen);
            } else if (!nioOutput.isDirect() && nioInput.isDirect()) {
                n = this.ctx.decompressDirectByteBufferToByteArray(nioOutput.array(), nioOutput.arrayOffset() + nioOutput.position(), nioOutput.limit() - nioOutput.position(), nioInput, nioInput.position(), inputLen);
            } else {
                throw new IllegalStateException("Unreachable line");
            }
            nioOutput.position(origOutputPos + n);
            nioInput.position(input.position() + inputLen);
            return n;
        }
        throw new IllegalStateException("At least one buffer is not a SingleByteBuff, this is not supported");
    }

    public void reinit(@Nullable Compression.HFileDecompressionContext newHFileDecompressionContext) {
        if (newHFileDecompressionContext != null) {
            if (newHFileDecompressionContext instanceof ZstdHFileDecompressionContext) {
                ZstdHFileDecompressionContext zstdContext = (ZstdHFileDecompressionContext)newHFileDecompressionContext;
                this.allowByteBuffDecompression = zstdContext.isAllowByteBuffDecompression();
                if (zstdContext.getDict() == null && this.dictId != 0) {
                    this.ctx.loadDict((byte[])null);
                    this.dictId = 0;
                } else if (zstdContext.getDictId() != this.dictId) {
                    this.ctx.loadDict(zstdContext.getDict());
                    this.dictId = zstdContext.getDictId();
                }
            } else {
                throw new IllegalArgumentException("ZstdByteBuffDecompression#reinit() was given an HFileDecompressionContext that was not a ZstdHFileDecompressionContext, this should never happen");
            }
        }
    }

    public void close() {
        this.ctx.close();
    }
}

