/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.brotli;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.Decoder;
import com.aayushatharva.brotli4j.decoder.DirectDecompress;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BrotliDecompressor
implements Decompressor {
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int inLen;
    protected boolean finished;

    BrotliDecompressor(int bufferSize) {
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        if (this.inBuf.position() > 0) {
            this.inBuf.flip();
            int remaining = this.inBuf.remaining();
            this.inLen -= remaining;
            this.outBuf.rewind();
            this.outBuf.limit(this.outBuf.capacity());
            byte[] inb = new byte[remaining];
            this.inBuf.get(inb);
            DirectDecompress result = Decoder.decompress((byte[])inb);
            this.outBuf.put(result.getDecompressedDataByteBuf().nioBuffer());
            int written = this.outBuf.position();
            this.inBuf.rewind();
            this.inBuf.limit(this.inBuf.capacity());
            this.outBuf.flip();
            int n = Math.min(written, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        this.finished = true;
        return 0;
    }

    public void end() {
    }

    public boolean finished() {
        return this.finished;
    }

    public int getRemaining() {
        return this.inLen;
    }

    public boolean needsDictionary() {
        return false;
    }

    public void reset() {
        this.inBuf.clear();
        this.inLen = 0;
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.finished = false;
    }

    public boolean needsInput() {
        return this.inBuf.position() == 0;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.inLen += len;
        this.finished = false;
    }

    static {
        Brotli4jLoader.ensureAvailability();
    }
}

