/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncBufferedMutator
extends Closeable {
    public TableName getName();

    public Configuration getConfiguration();

    default public CompletableFuture<Void> mutate(Mutation mutation) {
        return (CompletableFuture)Iterables.getOnlyElement(this.mutate(Collections.singletonList(mutation)));
    }

    public List<CompletableFuture<Void>> mutate(List<? extends Mutation> var1);

    public void flush();

    @Override
    public void close();

    public long getWriteBufferSize();

    public int getMaxMutations();

    default public long getPeriodicalFlushTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public Map<String, byte[]> getRequestAttributes() {
        return Collections.emptyMap();
    }
}

