/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.ParsedTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedJob
extends LoggedJob {
    private static final Logger LOG = LoggerFactory.getLogger(ParsedJob.class);
    private Map<String, Long> totalCountersMap = new HashMap<String, Long>();
    private Map<String, Long> mapCountersMap = new HashMap<String, Long>();
    private Map<String, Long> reduceCountersMap = new HashMap<String, Long>();
    private String jobConfPath;
    private Map<JobACL, AccessControlList> jobAcls;

    ParsedJob() {
    }

    ParsedJob(String jobID) {
        this.setJobID(jobID);
    }

    void putTotalCounters(Map<String, Long> totalCounters) {
        this.totalCountersMap = totalCounters;
    }

    public Map<String, Long> obtainTotalCounters() {
        return this.totalCountersMap;
    }

    void putMapCounters(Map<String, Long> mapCounters) {
        this.mapCountersMap = mapCounters;
    }

    public Map<String, Long> obtainMapCounters() {
        return this.mapCountersMap;
    }

    void putReduceCounters(Map<String, Long> reduceCounters) {
        this.reduceCountersMap = reduceCounters;
    }

    public Map<String, Long> obtainReduceCounters() {
        return this.reduceCountersMap;
    }

    void putJobConfPath(String confPath) {
        this.jobConfPath = confPath;
    }

    public String obtainJobConfpath() {
        return this.jobConfPath;
    }

    void putJobAcls(Map<JobACL, AccessControlList> acls) {
        this.jobAcls = acls;
    }

    public Map<JobACL, AccessControlList> obtainJobAcls() {
        return this.jobAcls;
    }

    public List<ParsedTask> obtainMapTasks() {
        List<LoggedTask> tasks = super.getMapTasks();
        return this.convertTasks(tasks);
    }

    public List<ParsedTask> obtainReduceTasks() {
        List<LoggedTask> tasks = super.getReduceTasks();
        return this.convertTasks(tasks);
    }

    public List<ParsedTask> obtainOtherTasks() {
        List<LoggedTask> tasks = super.getOtherTasks();
        return this.convertTasks(tasks);
    }

    private List<ParsedTask> convertTasks(List<LoggedTask> tasks) {
        ArrayList<ParsedTask> result = new ArrayList<ParsedTask>();
        for (LoggedTask t : tasks) {
            if (t instanceof ParsedTask) {
                result.add((ParsedTask)t);
                continue;
            }
            throw new RuntimeException("Unexpected type of tasks in the list...");
        }
        return result;
    }

    void dumpParsedJob() {
        LOG.info("ParsedJob details:" + this.obtainTotalCounters() + ";" + this.obtainMapCounters() + ";" + this.obtainReduceCounters() + "\n" + this.obtainJobConfpath() + "\n" + this.obtainJobAcls() + ";Q=" + (this.getQueue() == null ? "null" : this.getQueue().getValue()));
        List<ParsedTask> maps = this.obtainMapTasks();
        for (ParsedTask parsedTask : maps) {
            parsedTask.dumpParsedTask();
        }
        List<ParsedTask> reduces = this.obtainReduceTasks();
        for (ParsedTask task : reduces) {
            task.dumpParsedTask();
        }
        List<ParsedTask> list = this.obtainOtherTasks();
        for (ParsedTask task : list) {
            task.dumpParsedTask();
        }
    }
}

