/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructor;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MD5Hash;

@InterfaceAudience.Private
public class StripedBlockChecksumReconstructor
extends StripedReconstructor {
    private ByteBuffer targetBuffer;
    private final byte[] targetIndices;
    private byte[] checksumBuf;
    private DataOutputBuffer checksumWriter;
    private MD5Hash md5;
    private long checksumDataLen;
    private long requestedLen;

    public StripedBlockChecksumReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo, DataOutputBuffer checksumWriter, long requestedBlockLength) throws IOException {
        super(worker, stripedReconInfo);
        this.targetIndices = stripedReconInfo.getTargetIndices();
        assert (this.targetIndices != null);
        this.checksumWriter = checksumWriter;
        this.requestedLen = requestedBlockLength;
        this.init();
    }

    private void init() throws IOException {
        this.initDecoderIfNecessary();
        this.getStripedReader().init();
        this.targetBuffer = this.allocateBuffer(this.getBufferSize());
        long maxTargetLen = 0L;
        for (byte targetIndex : this.targetIndices) {
            maxTargetLen = Math.max(maxTargetLen, this.getBlockLen(targetIndex));
        }
        this.setMaxTargetLength(maxTargetLen);
        int checksumSize = this.getChecksum().getChecksumSize();
        int bytesPerChecksum = this.getChecksum().getBytesPerChecksum();
        int tmpLen = checksumSize * (this.getBufferSize() / bytesPerChecksum);
        this.checksumBuf = new byte[tmpLen];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconstruct() throws IOException {
        MessageDigest digester = MD5Hash.getDigester();
        long maxTargetLength = this.getMaxTargetLength();
        try {
            while (this.requestedLen > 0L && this.getPositionInBlock() < maxTargetLength) {
                long remaining = maxTargetLength - this.getPositionInBlock();
                int toReconstructLen = (int)Math.min((long)this.getStripedReader().getBufferSize(), remaining);
                this.getStripedReader().readMinimumSources(toReconstructLen);
                this.reconstructTargets(toReconstructLen);
                this.checksumDataLen += this.checksumWithTargetOutput(this.targetBuffer.array(), toReconstructLen, digester);
                this.updatePositionInBlock(toReconstructLen);
                this.requestedLen -= (long)toReconstructLen;
                this.clearBuffers();
            }
            byte[] digest = digester.digest();
            this.md5 = new MD5Hash(digest);
            this.md5.write((DataOutput)this.checksumWriter);
        }
        finally {
            this.cleanup();
        }
    }

    private long checksumWithTargetOutput(byte[] outputData, int toReconstructLen, MessageDigest digester) throws IOException {
        long checksumDataLength = 0L;
        if (this.requestedLen <= (long)toReconstructLen) {
            int remainingLen = (int)this.requestedLen;
            outputData = Arrays.copyOf(this.targetBuffer.array(), remainingLen);
            int partialLength = remainingLen % this.getChecksum().getBytesPerChecksum();
            int checksumRemaining = remainingLen / this.getChecksum().getBytesPerChecksum() * this.getChecksum().getChecksumSize();
            int dataOffset = 0;
            if (checksumRemaining > 0) {
                this.checksumBuf = new byte[checksumRemaining];
                this.getChecksum().calculateChunkedSums(outputData, dataOffset, remainingLen -= partialLength, this.checksumBuf, 0);
                digester.update(this.checksumBuf, 0, this.checksumBuf.length);
                checksumDataLength = this.checksumBuf.length;
                dataOffset = remainingLen;
            }
            if (partialLength > 0) {
                byte[] partialCrc = new byte[this.getChecksum().getChecksumSize()];
                this.getChecksum().reset();
                this.getChecksum().update(outputData, dataOffset, partialLength);
                this.getChecksum().writeValue(partialCrc, 0, true);
                digester.update(partialCrc);
                checksumDataLength += (long)partialCrc.length;
            }
            this.clearBuffers();
            return checksumDataLength;
        }
        this.getChecksum().calculateChunkedSums(outputData, 0, outputData.length, this.checksumBuf, 0);
        digester.update(this.checksumBuf, 0, this.checksumBuf.length);
        return this.checksumBuf.length;
    }

    private void reconstructTargets(int toReconstructLen) throws IOException {
        ByteBuffer[] inputs = this.getStripedReader().getInputBuffers(toReconstructLen);
        ByteBuffer[] outputs = new ByteBuffer[1];
        this.targetBuffer.limit(toReconstructLen);
        outputs[0] = this.targetBuffer;
        int[] tarIndices = new int[this.targetIndices.length];
        for (int i = 0; i < this.targetIndices.length; ++i) {
            tarIndices[i] = this.targetIndices[i];
        }
        this.getDecoder().decode(inputs, tarIndices, outputs);
    }

    private void clearBuffers() {
        this.getStripedReader().clearBuffers();
        this.targetBuffer.clear();
    }

    public MD5Hash getMD5() {
        return this.md5;
    }

    public long getChecksumDataLen() {
        return this.checksumDataLen;
    }
}

