/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ServiceException;
import io.opentracing.Scope;
import org.apache.hadoop.hdds.function.FunctionWithServiceException;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.slf4j.Logger;

public class OzoneProtocolMessageDispatcher<REQUEST, RESPONSE> {
    private String serviceName;
    private final ProtocolMessageMetrics protocolMessageMetrics;
    private Logger logger;

    public OzoneProtocolMessageDispatcher(String serviceName, ProtocolMessageMetrics protocolMessageMetrics, Logger logger) {
        this.serviceName = serviceName;
        this.protocolMessageMetrics = protocolMessageMetrics;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE processRequest(REQUEST request, FunctionWithServiceException<REQUEST, RESPONSE> methodCall, ProtocolMessageEnum type, String traceId) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope((String)type.toString(), (String)traceId);){
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[service={}] [type={}] request is received: <json>{}</json>", new Object[]{this.serviceName, type.toString(), request.toString().replaceAll("\n", "\\\\n")});
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} {} request is received", (Object)this.serviceName, (Object)type.toString());
            }
            this.protocolMessageMetrics.increment(type);
            Object response = methodCall.apply(request);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[service={}] [type={}] request is processed. Response: <json>{}</json>", new Object[]{this.serviceName, type.toString(), response.toString().replaceAll("\n", "\\\\n")});
            }
            Object object = response;
            return (RESPONSE)object;
        }
    }
}

