/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.hdds.utils.db.cache.TableCacheImpl;

public class TypedTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private final Table<byte[], byte[]> rawTable;
    private final CodecRegistry codecRegistry;
    private final Class<KEY> keyType;
    private final Class<VALUE> valueType;
    private final TableCache<CacheKey<KEY>, CacheValue<VALUE>> cache;
    private static final long EPOCH_DEFAULT = -1L;

    public TypedTable(Table<byte[], byte[]> rawTable, CodecRegistry codecRegistry, Class<KEY> keyType, Class<VALUE> valueType) throws IOException {
        this(rawTable, codecRegistry, keyType, valueType, TableCacheImpl.CacheCleanupPolicy.MANUAL);
    }

    public TypedTable(Table<byte[], byte[]> rawTable, CodecRegistry codecRegistry, Class<KEY> keyType, Class<VALUE> valueType, TableCacheImpl.CacheCleanupPolicy cleanupPolicy) throws IOException {
        this.rawTable = rawTable;
        this.codecRegistry = codecRegistry;
        this.keyType = keyType;
        this.valueType = valueType;
        this.cache = new TableCacheImpl<CacheKey<KEY>, CacheValue<VALUE>>(cleanupPolicy);
        if (cleanupPolicy == TableCacheImpl.CacheCleanupPolicy.NEVER) {
            try (TableIterator<KEY, TypedKeyValue> tableIterator = this.iterator();){
                while (tableIterator.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)tableIterator.next();
                    this.cache.loadInitial(new CacheKey(kv.getKey()), new CacheValue(Optional.of(kv.getValue()), -1L));
                }
            }
        }
    }

    @Override
    public void put(KEY key, VALUE value) throws IOException {
        byte[] keyData = this.codecRegistry.asRawData(key);
        byte[] valueData = this.codecRegistry.asRawData(value);
        this.rawTable.put(keyData, valueData);
    }

    @Override
    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws IOException {
        byte[] keyData = this.codecRegistry.asRawData(key);
        byte[] valueData = this.codecRegistry.asRawData(value);
        this.rawTable.putWithBatch(batch, keyData, valueData);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.rawTable.isEmpty();
    }

    @Override
    public boolean isExist(KEY key) throws IOException {
        CacheResult<CacheValue<VALUE>> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return true;
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return false;
        }
        return this.rawTable.isExist(this.codecRegistry.asRawData(key));
    }

    @Override
    public VALUE get(KEY key) throws IOException {
        CacheResult<CacheValue<VALUE>> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return this.codecRegistry.copyObject(cacheResult.getValue().getCacheValue(), this.valueType);
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTable(key);
    }

    private VALUE getFromTable(KEY key) throws IOException {
        byte[] keyBytes = this.codecRegistry.asRawData(key);
        byte[] valueBytes = this.rawTable.get(keyBytes);
        return this.codecRegistry.asObject(valueBytes, this.valueType);
    }

    @Override
    public void delete(KEY key) throws IOException {
        this.rawTable.delete(this.codecRegistry.asRawData(key));
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, KEY key) throws IOException {
        this.rawTable.deleteWithBatch(batch, this.codecRegistry.asRawData(key));
    }

    @Override
    public TableIterator<KEY, TypedKeyValue> iterator() {
        TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iterator = this.rawTable.iterator();
        return new TypedTableIterator(iterator, this.keyType, this.valueType);
    }

    @Override
    public String getName() throws IOException {
        return this.rawTable.getName();
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        return this.rawTable.getEstimatedKeyCount();
    }

    @Override
    public void close() throws Exception {
        this.rawTable.close();
    }

    @Override
    public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        this.cache.put(cacheKey, cacheValue);
    }

    @Override
    public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        return this.cache.get(cacheKey);
    }

    @Override
    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        return this.cache.iterator();
    }

    @Override
    public void cleanupCache(List<Long> epochs) {
        this.cache.cleanup(epochs);
    }

    @VisibleForTesting
    TableCache<CacheKey<KEY>, CacheValue<VALUE>> getCache() {
        return this.cache;
    }

    public Table<byte[], byte[]> getRawTable() {
        return this.rawTable;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public Class<KEY> getKeyType() {
        return this.keyType;
    }

    public Class<VALUE> getValueType() {
        return this.valueType;
    }

    public class TypedTableIterator
    implements TableIterator<KEY, TypedKeyValue> {
        private TableIterator<byte[], ? extends Table.KeyValue<byte[], byte[]>> rawIterator;
        private final Class<KEY> keyClass;
        private final Class<VALUE> valueClass;

        public TypedTableIterator(TableIterator<byte[], ? extends Table.KeyValue<byte[], byte[]>> rawIterator, Class<KEY> keyType, Class<VALUE> valueType) {
            this.rawIterator = rawIterator;
            this.keyClass = keyType;
            this.valueClass = valueType;
        }

        @Override
        public void seekToFirst() {
            this.rawIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.rawIterator.seekToLast();
        }

        @Override
        public TypedKeyValue seek(KEY key) throws IOException {
            byte[] keyBytes = TypedTable.this.codecRegistry.asRawData(key);
            Table.KeyValue<byte[], byte[]> result = this.rawIterator.seek(keyBytes);
            if (result == null) {
                return null;
            }
            return new TypedKeyValue(result);
        }

        @Override
        public KEY key() throws IOException {
            byte[] result = this.rawIterator.key();
            if (result == null) {
                return null;
            }
            return TypedTable.this.codecRegistry.asObject(result, this.keyClass);
        }

        @Override
        public TypedKeyValue value() {
            Table.KeyValue<byte[], byte[]> keyValue = this.rawIterator.value();
            if (keyValue != null) {
                return new TypedKeyValue(keyValue, this.keyClass, this.valueClass);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.rawIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public TypedKeyValue next() {
            return new TypedKeyValue((Table.KeyValue)this.rawIterator.next(), TypedTable.this.keyType, TypedTable.this.valueType);
        }
    }

    public class TypedKeyValue
    implements Table.KeyValue<KEY, VALUE> {
        private Table.KeyValue<byte[], byte[]> rawKeyValue;

        public TypedKeyValue(Table.KeyValue<byte[], byte[]> rawKeyValue) {
            this.rawKeyValue = rawKeyValue;
        }

        public TypedKeyValue(Table.KeyValue<byte[], byte[]> rawKeyValue, Class<KEY> keyType, Class<VALUE> valueType) {
            this.rawKeyValue = rawKeyValue;
        }

        @Override
        public KEY getKey() throws IOException {
            return TypedTable.this.codecRegistry.asObject(this.rawKeyValue.getKey(), TypedTable.this.keyType);
        }

        @Override
        public VALUE getValue() throws IOException {
            return TypedTable.this.codecRegistry.asObject(this.rawKeyValue.getValue(), TypedTable.this.valueType);
        }
    }
}

