/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.protobuf.ProtocolMessageEnum;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public class ProtocolMessageMetrics
implements MetricsSource {
    private String name;
    private String description;
    private Map<ProtocolMessageEnum, AtomicLong> counters = new ConcurrentHashMap<ProtocolMessageEnum, AtomicLong>();

    public static ProtocolMessageMetrics create(String name, String description, ProtocolMessageEnum[] types) {
        ProtocolMessageMetrics protocolMessageMetrics = new ProtocolMessageMetrics(name, description, types);
        return protocolMessageMetrics;
    }

    public ProtocolMessageMetrics(String name, String description, ProtocolMessageEnum[] values) {
        this.name = name;
        this.description = description;
        for (ProtocolMessageEnum value : values) {
            this.counters.put(value, new AtomicLong(0L));
        }
    }

    public void increment(ProtocolMessageEnum key) {
        this.counters.get(key).incrementAndGet();
    }

    public void register() {
        DefaultMetricsSystem.instance().register(this.name, this.description, (Object)this);
    }

    public void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.name);
        this.counters.forEach((key, value) -> builder.addCounter((MetricsInfo)new MetricName(key.toString(), ""), value.longValue()));
        builder.endRecord();
    }

    public static class MetricName
    implements MetricsInfo {
        private String name;
        private String description;

        public MetricName(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }
    }
}

