/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Optional;
import java.util.OptionalInt;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.HddsConfServlet;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.server.http.HttpServer2;
import org.apache.hadoop.hdds.server.http.LogStreamServlet;
import org.apache.hadoop.hdds.server.http.ProfileServlet;
import org.apache.hadoop.hdds.server.http.PrometheusMetricsSink;
import org.apache.hadoop.hdds.server.http.PrometheusServlet;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHttpServer.class);
    static final String PROMETHEUS_SINK = "PROMETHEUS_SINK";
    private static final String JETTY_BASETMPDIR = "org.eclipse.jetty.webapp.basetempdir";
    private HttpServer2 httpServer;
    private final Configuration conf;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private HttpConfig.Policy policy;
    private String name;
    private PrometheusMetricsSink prometheusMetricsSink;
    private boolean prometheusSupport;
    private boolean profilerSupport;

    public BaseHttpServer(Configuration conf, String name) throws IOException {
        this.name = name;
        this.conf = conf;
        this.policy = HttpConfig.getHttpPolicy(conf);
        if (this.isEnabled()) {
            String baseDir;
            this.httpAddress = this.getHttpBindAddress();
            this.httpsAddress = this.getHttpsBindAddress();
            conf.setBoolean("hadoop.prometheus.endpoint.enabled", false);
            HttpServer2.Builder builder = BaseHttpServer.newHttpServer2BuilderForOzone(conf, this.httpAddress, this.httpsAddress, name, this.getSpnegoPrincipal(), this.getKeytabFile());
            boolean xFrameEnabled = conf.getBoolean("dfs.xframe.enabled", true);
            String xFrameOptionValue = conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
            builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
            this.httpServer = builder.build();
            this.httpServer.addServlet("conf", "/conf", HddsConfServlet.class);
            this.httpServer.addServlet("logstream", "/logstream", LogStreamServlet.class);
            this.prometheusSupport = conf.getBoolean("hdds.prometheus.endpoint.enabled", true);
            this.profilerSupport = conf.getBoolean("hdds.profiler.endpoint.enabled", false);
            if (this.prometheusSupport) {
                this.prometheusMetricsSink = new PrometheusMetricsSink();
                this.httpServer.getWebAppContext().getServletContext().setAttribute(PROMETHEUS_SINK, (Object)this.prometheusMetricsSink);
                this.httpServer.addServlet("prometheus", "/prom", PrometheusServlet.class);
            }
            if (this.profilerSupport) {
                LOG.warn("/prof java profiling servlet is activated. Not safe for production!");
                this.httpServer.addServlet("profile", "/prof", ProfileServlet.class);
            }
            if (!StringUtils.isEmpty((CharSequence)(baseDir = conf.get("ozone.http.basedir")))) {
                this.httpServer.getWebAppContext().setAttribute(JETTY_BASETMPDIR, (Object)baseDir);
                LOG.info("HTTP server of {} uses base directory {}", (Object)name, (Object)baseDir);
            }
        }
    }

    public static HttpServer2.Builder newHttpServer2BuilderForOzone(Configuration conf, InetSocketAddress httpAddr, InetSocketAddress httpsAddr, String name, String spnegoUserNameKey, String spnegoKeytabFileKey) throws IOException {
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy(conf);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName(name).setConf(conf).setACL(new AccessControlList(conf.get("ozone.administrators", " "))).setSecurityEnabled(UserGroupInformation.isSecurityEnabled()).setUsernameConfKey(spnegoUserNameKey).setKeytabConfKey(spnegoKeytabFileKey);
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Starting web server as: " + SecurityUtil.getServerPrincipal((String)conf.get(spnegoUserNameKey), (String)httpAddr.getHostName()));
        }
        if (policy.isHttpEnabled()) {
            if (httpAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)httpAddr));
            builder.addEndpoint(uri);
            LOG.info("Starting Web-server for {} at: {}", (Object)name, (Object)uri);
        }
        if (policy.isHttpsEnabled() && httpsAddr != null) {
            Configuration sslConf = BaseHttpServer.loadSslConfiguration(conf);
            BaseHttpServer.loadSslConfToHttpServerBuilder(builder, sslConf);
            if (httpsAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("https://" + NetUtils.getHostPortString((InetSocketAddress)httpsAddr));
            builder.addEndpoint(uri);
            LOG.info("Starting Web-server for {} at: {}", (Object)name, (Object)uri);
        }
        return builder;
    }

    protected void addServlet(String servletName, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addServlet(servletName, pathSpec, clazz);
    }

    protected WebAppContext getWebAppContext() {
        return this.httpServer.getWebAppContext();
    }

    protected InetSocketAddress getBindAddress(String bindHostKey, String addressKey, String bindHostDefault, int bindPortdefault) {
        Optional bindHost = HddsUtils.getHostNameFromConfigKeys((Configuration)this.conf, (String[])new String[]{bindHostKey});
        OptionalInt addressPort = HddsUtils.getPortNumberFromConfigKeys((Configuration)this.conf, (String[])new String[]{addressKey});
        Optional addressHost = HddsUtils.getHostNameFromConfigKeys((Configuration)this.conf, (String[])new String[]{addressKey});
        String hostName = bindHost.orElse(addressHost.orElse(bindHostDefault));
        return NetUtils.createSocketAddr((String)(hostName + ":" + addressPort.orElse(bindPortdefault)));
    }

    public InetSocketAddress getHttpsBindAddress() {
        return this.getBindAddress(this.getHttpsBindHostKey(), this.getHttpsAddressKey(), this.getBindHostDefault(), this.getHttpsBindPortDefault());
    }

    public InetSocketAddress getHttpBindAddress() {
        return this.getBindAddress(this.getHttpBindHostKey(), this.getHttpAddressKey(), this.getBindHostDefault(), this.getHttpBindPortDefault());
    }

    public void start() throws IOException {
        if (this.httpServer != null && this.isEnabled()) {
            this.httpServer.start();
            if (this.prometheusSupport) {
                DefaultMetricsSystem.instance().register("prometheus", "Hadoop metrics prometheus exporter", (MetricsSink)this.prometheusMetricsSink);
            }
            this.updateConnectorAddress();
        }
    }

    private boolean isEnabled() {
        return this.conf.getBoolean(this.getEnabledKey(), true);
    }

    public void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    public void updateConnectorAddress() {
        String realAddress;
        int connIdx = 0;
        if (this.policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            realAddress = NetUtils.getHostPortString((InetSocketAddress)this.httpAddress);
            this.conf.set(this.getHttpAddressKey(), realAddress);
            LOG.info("HTTP server of {} listening at http://{}", (Object)this.name, (Object)realAddress);
        }
        if (this.policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            realAddress = NetUtils.getHostPortString((InetSocketAddress)this.httpsAddress);
            this.conf.set(this.getHttpsAddressKey(), realAddress);
            LOG.info("HTTPS server of {} listening at https://{}", (Object)this.name, (Object)realAddress);
        }
    }

    public static HttpServer2.Builder loadSslConfToHttpServerBuilder(HttpServer2.Builder builder, Configuration sslConf) {
        return builder.needsClientAuth(sslConf.getBoolean("ozone.https.client.need-auth", false)).keyPassword(BaseHttpServer.getPassword(sslConf, "ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), BaseHttpServer.getPassword(sslConf, "ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), BaseHttpServer.getPassword(sslConf, "ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list"));
    }

    public static String getSpnegoKeytabKey(Configuration conf, String defaultKey) {
        String value = conf.get("dfs.web.authentication.kerberos.keytab");
        return value == null || value.isEmpty() ? defaultKey : "dfs.web.authentication.kerberos.keytab";
    }

    static String getPassword(Configuration conf, String alias) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Setting password to null since IOException is caught when getting password", (Throwable)ioe);
            password = null;
        }
        return password;
    }

    public static Configuration loadSslConfiguration(Configuration conf) {
        String[] reqSslProps;
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("ozone.https.server.keystore.resource", "ssl-server.xml"));
        for (String sslProp : reqSslProps = new String[]{"ssl.server.truststore.location", "ssl.server.keystore.location", "ssl.server.keystore.password", "ssl.server.keystore.keypassword"}) {
            if (sslConf.get(sslProp) != null) continue;
            LOG.warn("SSL config {} is missing. If {} is specified, make sure it is a relative path", (Object)sslProp, (Object)"ozone.https.server.keystore.resource");
        }
        boolean requireClientAuth = conf.getBoolean("ozone.https.client.need-auth", false);
        sslConf.setBoolean("ozone.https.client.need-auth", requireClientAuth);
        return sslConf;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    protected abstract String getHttpAddressKey();

    protected abstract String getHttpsAddressKey();

    protected abstract String getHttpBindHostKey();

    protected abstract String getHttpsBindHostKey();

    protected abstract String getBindHostDefault();

    protected abstract int getHttpBindPortDefault();

    protected abstract int getHttpsBindPortDefault();

    protected abstract String getKeytabFile();

    protected abstract String getSpnegoPrincipal();

    protected abstract String getEnabledKey();
}

