/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificates.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.exceptions.CertificateException;
import org.apache.hadoop.hdds.security.x509.keys.SecurityUtil;
import org.apache.logging.log4j.util.Strings;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;

public final class CertificateSignRequest {
    private final KeyPair keyPair;
    private final SecurityConfig config;
    private final Extensions extensions;
    private String subject;
    private String clusterID;
    private String scmID;

    private CertificateSignRequest(String subject, String scmID, String clusterID, KeyPair keyPair, SecurityConfig config, Extensions extensions) {
        this.subject = subject;
        this.clusterID = clusterID;
        this.scmID = scmID;
        this.keyPair = keyPair;
        this.config = config;
        this.extensions = extensions;
    }

    private PKCS10CertificationRequest generateCSR() throws OperatorCreationException {
        X500Name dnName = SecurityUtil.getDistinguishedName(this.subject, this.scmID, this.clusterID);
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(dnName, this.keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder(this.config.getSignatureAlgo()).setProvider(this.config.getProvider()).build(this.keyPair.getPrivate());
        if (this.extensions != null) {
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)this.extensions);
        }
        return p10Builder.build(contentSigner);
    }

    public static String getEncodedString(PKCS10CertificationRequest request) throws IOException {
        PemObject pemObject = new PemObject("CERTIFICATE REQUEST", request.getEncoded());
        StringWriter str = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)str);){
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        return str.toString();
    }

    public static PKCS10CertificationRequest getCertificationRequest(String csr) throws IOException {
        try (PemReader reader = new PemReader((Reader)new StringReader(csr));){
            PemObject pemObject = reader.readPemObject();
            if (pemObject.getContent() == null) {
                throw new SCMSecurityException("Invalid Certificate signing request");
            }
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(pemObject.getContent());
            return pKCS10CertificationRequest;
        }
    }

    public static class Builder {
        private String subject;
        private String clusterID;
        private String scmID;
        private KeyPair key;
        private SecurityConfig config;
        private List<GeneralName> altNames;
        private Boolean ca = false;
        private boolean digitalSignature;
        private boolean digitalEncryption;

        public Builder setConfiguration(Configuration configuration) {
            this.config = new SecurityConfig(configuration);
            return this;
        }

        public Builder setKey(KeyPair keyPair) {
            this.key = keyPair;
            return this;
        }

        public Builder setSubject(String subjectString) {
            this.subject = subjectString;
            return this;
        }

        public Builder setClusterID(String s) {
            this.clusterID = s;
            return this;
        }

        public Builder setScmID(String s) {
            this.scmID = s;
            return this;
        }

        public Builder setDigitalSignature(boolean dSign) {
            this.digitalSignature = dSign;
            return this;
        }

        public Builder setDigitalEncryption(boolean dEncryption) {
            this.digitalEncryption = dEncryption;
            return this;
        }

        public Builder addDnsName(String dnsName) {
            Preconditions.checkNotNull((Object)dnsName, (Object)"dnsName cannot be null");
            this.addAltName(2, dnsName);
            return this;
        }

        public Builder addIpAddress(String ip) {
            Preconditions.checkNotNull((Object)ip, (Object)"Ip address cannot be null");
            this.addAltName(7, ip);
            return this;
        }

        public Builder addServiceName(String serviceName) {
            Preconditions.checkNotNull((Object)serviceName, (Object)"Service Name cannot be null");
            this.addAltName(0, serviceName);
            return this;
        }

        private Builder addAltName(int tag, String name) {
            if (this.altNames == null) {
                this.altNames = new ArrayList<GeneralName>();
            }
            if (tag == 0) {
                ASN1Object ono = this.addOtherNameAsn1Object(name);
                this.altNames.add(new GeneralName(tag, (ASN1Encodable)ono));
            } else {
                this.altNames.add(new GeneralName(tag, name));
            }
            return this;
        }

        private ASN1Object addOtherNameAsn1Object(String name) {
            String otherNameOID = "2.16.840.1.113730.3.1.34";
            ASN1EncodableVector otherName = new ASN1EncodableVector();
            otherName.add((ASN1Encodable)new ASN1ObjectIdentifier("2.16.840.1.113730.3.1.34"));
            otherName.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(name)));
            return new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(otherName));
        }

        public Builder setCA(Boolean isCA) {
            this.ca = isCA;
            return this;
        }

        private Extension getKeyUsageExtension() throws IOException {
            int keyUsageFlag = 8;
            if (this.digitalEncryption) {
                keyUsageFlag |= 0x30;
            }
            if (this.digitalSignature) {
                keyUsageFlag |= 0x80;
            }
            if (this.ca.booleanValue()) {
                keyUsageFlag |= 6;
            }
            KeyUsage keyUsage = new KeyUsage(keyUsageFlag);
            return new Extension(Extension.keyUsage, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)keyUsage));
        }

        private Optional<Extension> getSubjectAltNameExtension() throws IOException {
            if (this.altNames != null) {
                return Optional.of(new Extension(Extension.subjectAlternativeName, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)new GeneralNames(this.altNames.toArray(new GeneralName[this.altNames.size()])))));
            }
            return Optional.empty();
        }

        private Extension getBasicExtension() throws IOException {
            return new Extension(Extension.basicConstraints, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)new BasicConstraints(this.ca.booleanValue())));
        }

        private Extensions createExtensions() throws IOException {
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            if (this.ca.booleanValue()) {
                extensions.add(this.getBasicExtension());
            }
            extensions.add(this.getKeyUsageExtension());
            Optional<Extension> san = this.getSubjectAltNameExtension();
            if (san.isPresent()) {
                extensions.add(san.get());
            }
            return new Extensions(extensions.toArray(new Extension[extensions.size()]));
        }

        public PKCS10CertificationRequest build() throws SCMSecurityException {
            Preconditions.checkNotNull((Object)this.key, (Object)"KeyPair cannot be null");
            Preconditions.checkArgument((boolean)Strings.isNotBlank((String)this.subject), (Object)"Subject cannot be blank");
            try {
                CertificateSignRequest csr = new CertificateSignRequest(this.subject, this.scmID, this.clusterID, this.key, this.config, this.createExtensions());
                return csr.generateCSR();
            }
            catch (IOException ioe) {
                throw new CertificateException(String.format("Unable to create extension for certificate sign request for %s.", SecurityUtil.getDistinguishedName(this.subject, this.scmID, this.clusterID)), ioe.getCause());
            }
            catch (OperatorCreationException ex) {
                throw new CertificateException(String.format("Unable to create certificate sign request for %s.", SecurityUtil.getDistinguishedName(this.subject, this.scmID, this.clusterID)), ex.getCause());
            }
        }
    }
}

