/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Map<String, Integer> excludes = new HashMap<String, Integer>();
    private String includesFile;
    private String excludesFile;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.writeLock = rwLock.writeLock();
        this.readLock = rwLock.readLock();
        this.refresh();
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        this.includesFile = includesFile;
        this.excludesFile = excludesFile;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.writeLock = rwLock.writeLock();
        this.readLock = rwLock.readLock();
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            block3: while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = nodes[i].trim();
                    if (nodes[i].startsWith("#")) continue block3;
                    if (nodes[i].isEmpty()) continue;
                    LOG.info((Object)("Adding a node \"" + nodes[i] + "\" to the list of " + type + " hosts from " + filename));
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public void refresh() throws IOException {
        this.writeLock.lock();
        try {
            this.refresh(this.includesFile, this.excludesFile);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static void readFileToMap(String type, String filename, Map<String, Integer> map) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToMapWithFileInputStream(type, filename, fis, map);
    }

    public static void readFileToMapWithFileInputStream(String type, String filename, InputStream inputStream, Map<String, Integer> map) throws IOException {
        boolean xmlInput = filename.toLowerCase().endsWith(".xml");
        if (xmlInput) {
            HostsFileReader.readXmlFileToMapWithFileInputStream(type, filename, inputStream, map);
        } else {
            HashSet<String> nodes = new HashSet<String>();
            HostsFileReader.readFileToSetWithFileInputStream(type, filename, inputStream, nodes);
            for (String node : nodes) {
                map.put(node, null);
            }
        }
    }

    public static void readXmlFileToMapWithFileInputStream(String type, String filename, InputStream fileInputStream, Map<String, Integer> map) throws IOException {
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = builder.newDocumentBuilder();
            Document dom = db.parse(fileInputStream);
            Element doc = dom.getDocumentElement();
            NodeList nodes = doc.getElementsByTagName("host");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                String v = HostsFileReader.readFirstTagValue(e, "name");
                String[] hosts = StringUtils.getTrimmedStrings(v);
                String str = HostsFileReader.readFirstTagValue(e, "timeout");
                Integer timeout = str == null ? null : Integer.valueOf(Integer.parseInt(str));
                for (String host : hosts) {
                    map.put(host, timeout);
                    LOG.info((Object)("Adding a node \"" + host + "\" to the list of " + type + " hosts from " + filename));
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.fatal((Object)("error parsing " + filename), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            fileInputStream.close();
        }
    }

    static String readFirstTagValue(Element e, String tag) {
        NodeList nodes = e.getElementsByTagName(tag);
        return nodes.getLength() == 0 ? null : nodes.item(0).getTextContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String includeFiles, String excludeFiles) throws IOException {
        LOG.info((Object)"Refreshing hosts (include/exclude) list");
        this.writeLock.lock();
        try {
            this.updateFileNames(includeFiles, excludeFiles);
            HashSet<String> newIncludes = new HashSet<String>();
            HashMap<String, Integer> newExcludes = new HashMap<String, Integer>();
            boolean switchIncludes = false;
            boolean switchExcludes = false;
            if (includeFiles != null && !includeFiles.isEmpty()) {
                HostsFileReader.readFileToSet("included", includeFiles, newIncludes);
                switchIncludes = true;
            }
            if (excludeFiles != null && !excludeFiles.isEmpty()) {
                HostsFileReader.readFileToMap("excluded", excludeFiles, newExcludes);
                switchExcludes = true;
            }
            if (switchIncludes) {
                this.includes = newIncludes;
            }
            if (switchExcludes) {
                this.excludes = newExcludes;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info((Object)"Refreshing hosts (include/exclude) list");
        this.writeLock.lock();
        try {
            HashSet<String> newIncludes = new HashSet<String>();
            HashMap<String, Integer> newExcludes = new HashMap<String, Integer>();
            boolean switchIncludes = false;
            boolean switchExcludes = false;
            if (inFileInputStream != null) {
                HostsFileReader.readFileToSetWithFileInputStream("included", this.includesFile, inFileInputStream, newIncludes);
                switchIncludes = true;
            }
            if (exFileInputStream != null) {
                HostsFileReader.readFileToMapWithFileInputStream("excluded", this.excludesFile, exFileInputStream, newExcludes);
                switchExcludes = true;
            }
            if (switchIncludes) {
                this.includes = newIncludes;
            }
            if (switchExcludes) {
                this.excludes = newExcludes;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getHosts() {
        this.readLock.lock();
        try {
            Set<String> set = this.includes;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getExcludedHosts() {
        this.readLock.lock();
        try {
            Set<String> set = this.excludes.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getHostDetails(Set<String> includes, Set<String> excludes) {
        this.readLock.lock();
        try {
            includes.addAll(this.includes);
            excludes.addAll(this.excludes.keySet());
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getHostDetails(Set<String> includeHosts, Map<String, Integer> excludeHosts) {
        this.readLock.lock();
        try {
            includeHosts.addAll(this.includes);
            excludeHosts.putAll(this.excludes);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setIncludesFile(String includesFile) {
        LOG.info((Object)("Setting the includes file to " + includesFile));
        this.includesFile = includesFile;
    }

    public void setExcludesFile(String excludesFile) {
        LOG.info((Object)("Setting the excludes file to " + excludesFile));
        this.excludesFile = excludesFile;
    }

    public void updateFileNames(String includeFiles, String excludeFiles) {
        this.writeLock.lock();
        try {
            this.setIncludesFile(includeFiles);
            this.setExcludesFile(excludeFiles);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

