/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.core.GrailsApplication;
import grails.util.GrailsNameUtils;
import grails.web.CamelCaseUrlConverter;
import grails.web.UrlConverter;
import grails.web.mapping.UrlMappingData;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.exceptions.UrlMappingException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.web.mapping.AbstractUrlMappingInfo;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class DefaultUrlMappingInfo
extends AbstractUrlMappingInfo {
    private static final Log LOG = LogFactory.getLog(DefaultUrlMappingInfo.class);
    private static final String SETTING_GRAILS_WEB_DISABLE_MULTIPART = "grails.web.disable.multipart";
    private static final String CONTROLLER_PREFIX = "controller:";
    private static final String ACTION_PREFIX = "action:";
    private static final String PLUGIN_PREFIX = "plugin:";
    private static final String NAMESPACE_PREFIX = "namespace:";
    private static final String ID_PREFIX = "id:";
    private static final String VIEW_PREFIX = "view:";
    private static final String METHOD_PREFIX = "method:";
    private static final String VERSION_PREFIX = "version:";
    private final GrailsApplication grailsApplication;
    private Object controllerName;
    private Object actionName;
    private Object pluginName;
    private Object namespace;
    private Object redirectInfo;
    private Object id;
    private static final String ID_PARAM = "id";
    private UrlMappingData urlData;
    private Object viewName;
    private boolean parsingRequest;
    private Object uri;
    private UrlConverter urlConverter;
    private String httpMethod;
    private String version;

    private DefaultUrlMappingInfo(Map params, UrlMappingData urlData, GrailsApplication grailsApplication) {
        this.setParams(params);
        this.id = this.getParams().get(ID_PARAM);
        this.urlData = urlData;
        this.grailsApplication = grailsApplication;
        ApplicationContext applicationContext = null;
        if (grailsApplication != null) {
            applicationContext = grailsApplication.getMainContext();
        }
        this.urlConverter = applicationContext != null && applicationContext.containsBean("grailsUrlConverter") ? (UrlConverter)applicationContext.getBean("grailsUrlConverter", UrlConverter.class) : new CamelCaseUrlConverter();
    }

    public DefaultUrlMappingInfo(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, Map params, UrlMappingData urlData, GrailsApplication grailsApplication) {
        this(redirectInfo, controllerName, actionName, namespace, pluginName, viewName, null, "*", params, urlData, grailsApplication);
    }

    public DefaultUrlMappingInfo(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, Map<?, ?> params, UrlMappingData urlData, GrailsApplication grailsApplication) {
        this(params, urlData, grailsApplication);
        Assert.isTrue((redirectInfo != null || controllerName != null || viewName != null ? 1 : 0) != 0, (String)"URL mapping must either provide redirect information, a controller or a view name to map to!");
        Assert.notNull(params, (String)"Argument [params] cannot be null");
        this.controllerName = controllerName;
        this.actionName = actionName;
        this.pluginName = pluginName;
        this.namespace = namespace;
        this.httpMethod = httpMethod;
        this.version = version;
        this.redirectInfo = redirectInfo;
        if (actionName == null) {
            this.viewName = viewName;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public DefaultUrlMappingInfo(Object viewName, Map params, UrlMappingData urlData, GrailsApplication grailsApplication) {
        this(params, urlData, grailsApplication);
        this.viewName = viewName;
        Assert.notNull((Object)viewName, (String)"Argument [viewName] cannot be null or blank");
    }

    public DefaultUrlMappingInfo(Object uri, UrlMappingData data, GrailsApplication grailsApplication) {
        this(Collections.emptyMap(), data, grailsApplication);
        this.uri = uri;
        Assert.notNull((Object)uri, (String)"Argument [uri] cannot be null or blank");
    }

    public DefaultUrlMappingInfo(Object uri, String httpMethod, UrlMappingData data, GrailsApplication grailsApplication) {
        this(Collections.emptyMap(), data, grailsApplication);
        this.uri = uri;
        this.httpMethod = httpMethod;
        Assert.notNull((Object)uri, (String)"Argument [uri] cannot be null or blank");
    }

    public DefaultUrlMappingInfo(UrlMappingInfo info, Map params, GrailsApplication grailsApplication) {
        this(params, info.getUrlData(), grailsApplication);
        this.redirectInfo = info.getRedirectInfo();
        this.controllerName = info.getControllerName();
        this.actionName = info.getActionName();
        this.namespace = info.getNamespace();
        this.pluginName = info.getPluginName();
        this.viewName = info.getViewName();
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        if (this.urlData == null) {
            return null;
        }
        return this.urlData.getUrlPattern();
    }

    @Override
    public Map getParameters() {
        return this.getParams();
    }

    @Override
    public boolean isParsingRequest() {
        return this.parsingRequest;
    }

    public void setParsingRequest(boolean parsingRequest) {
        this.parsingRequest = parsingRequest;
    }

    @Override
    public String getPluginName() {
        return this.pluginName == null ? null : this.pluginName.toString();
    }

    @Override
    public String getNamespace() {
        String name = this.evaluateNameForValue(this.namespace);
        return this.urlConverter.toUrlElement(name);
    }

    @Override
    public String getControllerName() {
        String name = this.evaluateNameForValue(this.controllerName);
        if (name == null && this.getViewName() == null && this.uri == null) {
            throw new UrlMappingException("Unable to establish controller name to dispatch for [" + String.valueOf(this.controllerName) + "]. Dynamic closure invocation returned null. Check your mapping file is correct, when assigning the controller name as a request parameter it cannot be an optional token!");
        }
        return this.urlConverter.toUrlElement(name);
    }

    @Override
    public String getActionName() {
        String name;
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        String string = name = webRequest == null ? null : this.checkDispatchAction(webRequest.getCurrentRequest());
        if (name == null) {
            name = this.evaluateNameForValue(this.actionName, webRequest);
        }
        return this.urlConverter.toUrlElement(name);
    }

    @Override
    public String getViewName() {
        return this.evaluateNameForValue(this.viewName);
    }

    @Override
    public String getId() {
        return this.evaluateNameForValue(this.id);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private String checkDispatchAction(HttpServletRequest request) {
        if (request.getAttribute("exception") != null || WebUtils.isForwardOrInclude((HttpServletRequest)request)) {
            return null;
        }
        String dispatchActionName = null;
        Enumeration<String> paramNames = this.tryMultipartParams(request, request.getParameterNames());
        while (paramNames.hasMoreElements()) {
            String name = paramNames.nextElement();
            if (!name.startsWith("_action_")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                name = name.substring(0, name.length() - 2);
            }
            dispatchActionName = GrailsNameUtils.getPropertyNameRepresentation((String)name.substring("_action_".length()));
            break;
        }
        if (LOG.isWarnEnabled() && dispatchActionName != null) {
            LOG.warn((Object)String.format("Dispatch Action [%s] detected; Dispatch Actions will be removed in a future version of Grails. Use g: formActionSubmit instead.", dispatchActionName));
        }
        return dispatchActionName;
    }

    private Enumeration<String> tryMultipartParams(HttpServletRequest request, Enumeration<String> originalParams) {
        MultipartResolver resolver;
        Enumeration paramNames = originalParams;
        boolean disabled = this.isMultipartDisabled();
        if (!disabled && (resolver = this.getMultipartResolver()) != null && resolver.isMultipart(request)) {
            MultipartHttpServletRequest resolvedMultipartRequest = this.getResolvedRequest(request, resolver);
            paramNames = resolvedMultipartRequest.getParameterNames();
        }
        return paramNames;
    }

    private MultipartHttpServletRequest getResolvedRequest(HttpServletRequest request, MultipartResolver resolver) {
        MultipartHttpServletRequest resolvedMultipartRequest = (MultipartHttpServletRequest)request.getAttribute(MultipartHttpServletRequest.class.getName());
        if (resolvedMultipartRequest == null) {
            resolvedMultipartRequest = resolver.resolveMultipart(request);
            request.setAttribute(MultipartHttpServletRequest.class.getName(), (Object)resolvedMultipartRequest);
        }
        return resolvedMultipartRequest;
    }

    private boolean isMultipartDisabled() {
        if (this.grailsApplication != null) {
            return (Boolean)this.grailsApplication.getConfig().getProperty(SETTING_GRAILS_WEB_DISABLE_MULTIPART, Boolean.class, (Object)false);
        }
        return false;
    }

    private MultipartResolver getMultipartResolver() {
        ApplicationContext ctx;
        if (this.grailsApplication != null && (ctx = this.grailsApplication.getMainContext()) != null) {
            return (MultipartResolver)ctx.getBean("multipartResolver");
        }
        return null;
    }

    @Override
    public String getURI() {
        return this.evaluateNameForValue(this.uri);
    }

    @Override
    public Object getRedirectInfo() {
        return this.redirectInfo;
    }

    @Override
    public UrlMappingData getUrlData() {
        return this.urlData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUrlMappingInfo that = (DefaultUrlMappingInfo)o;
        if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) {
            return false;
        }
        if (this.controllerName != null ? !this.controllerName.equals(that.controllerName) : that.controllerName != null) {
            return false;
        }
        if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
            return false;
        }
        if (this.redirectInfo != null ? !this.redirectInfo.equals(that.redirectInfo) : that.redirectInfo != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.viewName != null ? !this.viewName.equals(that.viewName) : that.viewName != null);
    }

    public int hashCode() {
        int result = this.controllerName != null ? (CONTROLLER_PREFIX + String.valueOf(this.controllerName)).hashCode() : 0;
        result = 31 * result + (this.actionName != null ? (ACTION_PREFIX + String.valueOf(this.actionName)).hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? (PLUGIN_PREFIX + String.valueOf(this.pluginName)).hashCode() : 0);
        result = 31 * result + (this.namespace != null ? (NAMESPACE_PREFIX + String.valueOf(this.namespace)).hashCode() : 0);
        result = 31 * result + (this.redirectInfo != null ? this.redirectInfo.hashCode() : 0);
        result = 31 * result + (this.id != null ? (ID_PREFIX + String.valueOf(this.id)).hashCode() : 0);
        result = 31 * result + (this.viewName != null ? (VIEW_PREFIX + String.valueOf(this.viewName)).hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? (METHOD_PREFIX + this.httpMethod).hashCode() : 0);
        result = 31 * result + (this.version != null ? (VERSION_PREFIX + this.version).hashCode() : 0);
        return result;
    }
}

