/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet;

import grails.core.GrailsApplication;
import grails.core.GrailsControllerClass;
import grails.plugins.GrailsPluginManager;
import grails.util.Holders;
import grails.web.mvc.FlashScope;
import grails.web.pages.GroovyPagesUriService;
import groovy.lang.GroovyObject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.gsp.ResourceAwareTemplateEngine;
import org.grails.web.pages.DefaultGroovyPagesUriService;
import org.grails.web.servlet.GrailsFlashScope;
import org.grails.web.util.GrailsApplicationAttributes;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.web.util.UrlPathHelper;

public class DefaultGrailsApplicationAttributes
implements GrailsApplicationAttributes {
    protected static final String DEFAULT_NAMESPACE = "g";
    private static Log LOG = LogFactory.getLog(DefaultGrailsApplicationAttributes.class);
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private ServletContext context;
    private ApplicationContext appContext;
    private ResourceAwareTemplateEngine pagesTemplateEngine;
    private GrailsApplication grailsApplication;
    private GroovyPagesUriService groovyPagesUriService;
    private MessageSource messageSource;
    private GrailsPluginManager pluginManager;

    public DefaultGrailsApplicationAttributes(ServletContext context) {
        this.context = context;
        if (context != null) {
            this.appContext = (ApplicationContext)context.getAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT");
            if (this.appContext == null) {
                this.appContext = Holders.findApplicationContext();
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    private GrailsPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = (GrailsPluginManager)this.fetchBeanFromAppCtx("pluginManager");
        }
        return this.pluginManager;
    }

    private <T> T fetchBeanFromAppCtx(String name) {
        if (this.appContext == null) {
            return null;
        }
        try {
            if (this.appContext.containsBean(name)) {
                return (T)this.appContext.getBean(name);
            }
            return null;
        }
        catch (BeansException e) {
            LOG.warn((Object)("Bean named '" + name + "' is missing."));
            return null;
        }
    }

    @Override
    public String getPluginContextPath(HttpServletRequest request) {
        GroovyObject controller = this.getController((ServletRequest)request);
        if (controller != null && this.getPluginManager() != null) {
            String path = this.getPluginManager().getPluginPathForInstance((Object)controller);
            return path == null ? "" : path;
        }
        return "";
    }

    @Override
    public GroovyObject getController(ServletRequest request) {
        return (GroovyObject)request.getAttribute("org.grails.CONTROLLER");
    }

    @Override
    public String getControllerUri(ServletRequest request) {
        return "/" + this.getControllerName(request);
    }

    private String getControllerName(ServletRequest request) {
        GroovyObject controller;
        String controllerName = (String)request.getAttribute("org.grails.CONTROLLER_NAME_ATTRIBUTE");
        if ((controllerName == null || controllerName.length() == 0) && (controller = this.getController(request)) != null) {
            String namespace;
            controllerName = (String)controller.getProperty("controllerName");
            request.setAttribute("org.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
            if (controller instanceof GrailsControllerClass && (namespace = ((GrailsControllerClass)controller).getNamespace()) != null) {
                request.setAttribute("org.grails.CONTROLLER_NAMESPACE_ATTRIBUTE", (Object)namespace);
            }
        }
        return controllerName != null ? controllerName : "";
    }

    @Override
    @Deprecated
    public String getApplicationUri(ServletRequest request) {
        String appUri = (String)request.getAttribute("org.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath((HttpServletRequest)request);
        }
        return appUri;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public FlashScope getFlashScope(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpSession session = servletRequest.getSession(false);
        FlashScope fs = session != null ? (FlashScope)session.getAttribute("org.grails.FLASH_SCOPE") : (FlashScope)request.getAttribute("org.grails.FLASH_SCOPE");
        if (fs == null) {
            fs = new GrailsFlashScope();
            if (session != null) {
                session.setAttribute("org.grails.FLASH_SCOPE", (Object)fs);
            } else {
                request.setAttribute("org.grails.FLASH_SCOPE", (Object)fs);
            }
        }
        return fs;
    }

    @Override
    public String getTemplateUri(CharSequence templateName, ServletRequest request) {
        Assert.notNull((Object)templateName, (String)"Argument [template] cannot be null");
        return this.getGroovyPagesUriService().getTemplateURI(this.getControllerName(request), templateName.toString());
    }

    @Override
    public String getViewUri(String viewName, HttpServletRequest request) {
        Assert.notNull((Object)viewName, (String)"Argument [view] cannot be null");
        return this.getGroovyPagesUriService().getDeployedViewURI(this.getControllerName((ServletRequest)request), viewName);
    }

    @Override
    public String getControllerActionUri(ServletRequest request) {
        GroovyObject controller = this.getController(request);
        return (String)controller.getProperty("actionUri");
    }

    @Override
    public Errors getErrors(ServletRequest request) {
        return (Errors)request.getAttribute("org.grails.ERRORS");
    }

    @Override
    public ResourceAwareTemplateEngine getPagesTemplateEngine() {
        if (this.pagesTemplateEngine == null) {
            this.pagesTemplateEngine = (ResourceAwareTemplateEngine)this.fetchBeanFromAppCtx("groovyPagesTemplateEngine");
        }
        if (this.pagesTemplateEngine == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"No bean named [groovyPagesTemplateEngine] defined in Spring application context!");
        }
        return this.pagesTemplateEngine;
    }

    public GrailsApplication getGrailsApplication() {
        if (this.grailsApplication == null) {
            this.grailsApplication = (GrailsApplication)this.fetchBeanFromAppCtx("grailsApplication");
            if (this.grailsApplication == null) {
                this.grailsApplication = Holders.findApplication();
            }
        }
        return this.grailsApplication;
    }

    @Override
    public Writer getOut(HttpServletRequest request) {
        return (Writer)request.getAttribute("org.grails.RESPONSE_OUT");
    }

    @Override
    public void setOut(HttpServletRequest request, Writer out2) {
        request.setAttribute("org.grails.RESPONSE_OUT", (Object)out2);
    }

    @Override
    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        return this.getGroovyPagesUriService().getNoSuffixViewURI(controller, viewName);
    }

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.getGroovyPagesUriService().getTemplateURI(controller, templateName);
    }

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName, boolean includeExtension) {
        return this.getGroovyPagesUriService().getTemplateURI(controller, templateName, includeExtension);
    }

    @Override
    public GroovyPagesUriService getGroovyPagesUriService() {
        if (this.groovyPagesUriService == null) {
            this.groovyPagesUriService = (GroovyPagesUriService)this.fetchBeanFromAppCtx("groovyPagesUriService");
            if (this.groovyPagesUriService == null) {
                this.groovyPagesUriService = new DefaultGroovyPagesUriService();
            }
        }
        return this.groovyPagesUriService;
    }

    @Override
    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            this.messageSource = (MessageSource)this.fetchBeanFromAppCtx("messageSource");
        }
        return this.messageSource;
    }
}

