/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.run;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import org.grails.cli.command.run.SpringApplicationRunner;
import org.grails.cli.command.run.SpringApplicationRunnerConfiguration;
import org.grails.cli.compiler.GroovyCompilerScope;
import org.grails.cli.compiler.RepositoryConfigurationFactory;
import org.grails.cli.compiler.grape.RepositoryConfiguration;
import org.grails.cli.profile.Command;
import org.grails.cli.profile.CommandDescription;
import org.grails.cli.profile.ExecutionContext;

public class RunCommand
implements Command {
    public static final String NAME = "run";
    private final Object monitor = new Object();
    private SpringApplicationRunner runner;

    public String getName() {
        return NAME;
    }

    @Override
    public CommandDescription getDescription() {
        CommandDescription description = new CommandDescription();
        description.setName(NAME);
        description.setDescription("Run a grails groovy script");
        description.setUsage("run [SCRIPT NAME]");
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean handle(ExecutionContext executionContext) {
        Object object = this.monitor;
        synchronized (object) {
            String[] sources = executionContext.getCommandLine().getRemainingArgs().toArray(new String[0]);
            List<RepositoryConfiguration> repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
            repositoryConfiguration.add(0, new RepositoryConfiguration("local", new File("repository").toURI(), true));
            SpringApplicationRunnerConfigurationAdapter configuration = new SpringApplicationRunnerConfigurationAdapter(repositoryConfiguration);
            try {
                this.runner = new SpringApplicationRunner(configuration, sources, new String[0]);
                this.runner.compileAndRun();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    static class SpringApplicationRunnerConfigurationAdapter
    implements SpringApplicationRunnerConfiguration {
        private final List<RepositoryConfiguration> repositoryConfiguration;

        public SpringApplicationRunnerConfigurationAdapter(List<RepositoryConfiguration> repositoryConfiguration) {
            this.repositoryConfiguration = repositoryConfiguration;
        }

        @Override
        public boolean isWatchForFileChanges() {
            return true;
        }

        @Override
        public Level getLogLevel() {
            return Level.INFO;
        }

        @Override
        public GroovyCompilerScope getScope() {
            return GroovyCompilerScope.DEFAULT;
        }

        @Override
        public boolean isGuessImports() {
            return true;
        }

        @Override
        public boolean isGuessDependencies() {
            return true;
        }

        @Override
        public boolean isAutoconfigure() {
            return true;
        }

        @Override
        public String[] getClasspath() {
            return new String[0];
        }

        @Override
        public List<RepositoryConfiguration> getRepositoryConfiguration() {
            return this.repositoryConfiguration;
        }

        @Override
        public boolean isQuiet() {
            return false;
        }
    }
}

