/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.boot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SpringApplicationLauncher {
    private static final String DEFAULT_SPRING_APPLICATION_CLASS = "org.springframework.boot.SpringApplication";
    private final ClassLoader classLoader;

    public SpringApplicationLauncher(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object launch(Class<?>[] sources, String[] args) throws Exception {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("spring.groovy.template.check-template-location", "false");
        Class<?> applicationClass = Class.forName(this.getSpringApplicationClassName(), false, this.classLoader);
        Constructor<?> constructor = applicationClass.getDeclaredConstructor(Class[].class);
        constructor.setAccessible(true);
        Object application = constructor.newInstance(new Object[]{sources});
        applicationClass.getMethod("setDefaultProperties", Map.class).invoke(application, defaultProperties);
        Method method = applicationClass.getMethod("run", String[].class);
        return method.invoke(application, new Object[]{args});
    }

    private String getSpringApplicationClassName() {
        String className = System.getProperty("spring.application.class.name");
        if (className == null) {
            className = this.getEnvironmentVariable("SPRING_APPLICATION_CLASS_NAME");
        }
        if (className == null) {
            className = DEFAULT_SPRING_APPLICATION_CLASS;
        }
        return className;
    }

    protected String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }
}

