/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.install;

import java.util.Collection;
import java.util.List;
import joptsimple.OptionSet;
import org.grails.cli.command.install.Installer;
import org.grails.cli.command.options.CompilerOptionHandler;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.Assert;

public class InstallCommand
extends OptionParsingCommand {
    public InstallCommand() {
        super("install", "Install dependencies to the lib/ext directory", (OptionHandler)new InstallOptionHandler());
    }

    public String getUsageHelp() {
        return "[options] <coordinates>";
    }

    private static final class InstallOptionHandler
    extends CompilerOptionHandler {
        private InstallOptionHandler() {
        }

        protected ExitStatus run(OptionSet options) throws Exception {
            List args = options.nonOptionArguments();
            Assert.notEmpty((Collection)args, (String)"Please specify at least one dependency, in the form group:artifact:version, to install");
            try {
                new Installer(options, this).install(args);
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                Log.error((String)(message != null ? message : ex.getClass().toString()));
            }
            return ExitStatus.OK;
        }
    }
}

