/*
 * Decompiled with CFR 0.152.
 */
package org.apache.grails.web.layout;

import jakarta.servlet.ServletContext;
import java.util.Locale;
import org.apache.grails.web.layout.EmbeddedGrailsLayoutView;
import org.apache.grails.web.layout.GroovyPageLayoutFinder;
import org.grails.web.servlet.view.LayoutViewResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class EmbeddedGrailsLayoutViewResolver
implements LayoutViewResolver,
Ordered,
ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedGrailsLayoutViewResolver.class);
    protected ViewResolver innerViewResolver;
    protected GroovyPageLayoutFinder groovyPageLayoutFinder;
    private int order = 2147483617;
    protected ServletContext servletContext;

    public EmbeddedGrailsLayoutViewResolver(ViewResolver innerViewResolver, GroovyPageLayoutFinder groovyPageLayoutFinder) {
        this.innerViewResolver = innerViewResolver;
        this.groovyPageLayoutFinder = groovyPageLayoutFinder;
    }

    public EmbeddedGrailsLayoutViewResolver() {
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        View innerView;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving view for name {} and locale {}", (Object)viewName, (Object)locale);
        }
        if ((innerView = this.innerViewResolver.resolveViewName(viewName, locale)) == null) {
            return null;
        }
        if (innerView instanceof SmartView && ((SmartView)innerView).isRedirectView()) {
            return innerView;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating layout view name {} and locale {}", (Object)viewName, (Object)locale);
        }
        return this.createLayoutView(innerView);
    }

    protected View createLayoutView(View innerView) {
        return new EmbeddedGrailsLayoutView(this.groovyPageLayoutFinder, innerView);
    }

    public ViewResolver getInnerViewResolver() {
        return this.innerViewResolver;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setInnerViewResolver(ViewResolver innerViewResolver) {
        this.innerViewResolver = innerViewResolver;
    }

    public void setGroovyPageLayoutFinder(GroovyPageLayoutFinder groovyPageLayoutFinder) {
        this.groovyPageLayoutFinder = groovyPageLayoutFinder;
    }
}

