/*
 * Decompiled with CFR 0.152.
 */
package org.apache.grails.web.layout;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import grails.util.Environment;
import grails.util.GrailsClassUtils;
import grails.util.GrailsNameUtils;
import grails.util.GrailsStringUtils;
import groovy.lang.GroovyObject;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.grails.web.layout.GSPGrailsLayoutPage;
import org.apache.grails.web.layout.GrailsLayoutDecoratorMapper;
import org.apache.grails.web.layout.SpringMVCViewDecorator;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.view.AbstractGrailsView;
import org.grails.web.servlet.view.GrailsViewResolver;
import org.grails.web.servlet.view.LayoutViewResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class GroovyPageLayoutFinder
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(GrailsLayoutDecoratorMapper.class);
    private static final long LAYOUT_CACHE_EXPIRATION_MILLIS = Long.getLong("grails.gsp.reload.interval", 5000L);
    private static final String LAYOUTS_PATH = "/layouts";
    private static final int ORDER = 0x7FFFFFFE;
    private Map<String, DecoratorCacheValue> decoratorCache = new ConcurrentHashMap<String, DecoratorCacheValue>();
    private Map<LayoutCacheKey, DecoratorCacheValue> layoutDecoratorCache = new ConcurrentHashMap<LayoutCacheKey, DecoratorCacheValue>();
    private String defaultDecoratorName;
    private boolean gspReloadEnabled;
    private boolean cacheEnabled = Environment.getCurrent() != Environment.DEVELOPMENT;
    private ViewResolver viewResolver;
    private boolean enableNonGspViews = false;

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public void setDefaultDecoratorName(String defaultDecoratorName) {
        this.defaultDecoratorName = defaultDecoratorName;
    }

    public void setEnableNonGspViews(boolean enableNonGspViews) {
        this.enableNonGspViews = enableNonGspViews;
    }

    public void setGspReloadEnabled(boolean gspReloadEnabled) {
        this.gspReloadEnabled = gspReloadEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver instanceof LayoutViewResolver ? ((LayoutViewResolver)viewResolver).getInnerViewResolver() : viewResolver;
    }

    public Decorator findLayout(HttpServletRequest request, Content page) {
        return this.findLayout(request, (Page)GSPGrailsLayoutPage.content2htmlPage(page));
    }

    public Decorator findLayout(HttpServletRequest request, Page page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluating layout for request: {}", (Object)request.getRequestURI());
        }
        Object layoutAttribute = request.getAttribute("org.grails.layout.name");
        if (request.getAttribute("org.grails.rendering.view") != null || layoutAttribute != null) {
            String layoutName;
            String string = layoutName = layoutAttribute == null ? null : layoutAttribute.toString();
            if (layoutName == null) {
                layoutName = page.getProperty("meta.layout");
            }
            Decorator d = null;
            if (GrailsStringUtils.isBlank((String)layoutName)) {
                GroovyObject controller = (GroovyObject)request.getAttribute("org.grails.CONTROLLER");
                if (controller != null) {
                    GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
                    String controllerName = webRequest.getControllerName();
                    if (controllerName == null) {
                        controllerName = GrailsNameUtils.getLogicalPropertyName((String)controller.getClass().getName(), (String)"Controller");
                    }
                    String actionUri = webRequest.getAttributes().getControllerActionUri((ServletRequest)request);
                    if (controllerName != null && actionUri != null) {
                        DecoratorCacheValue cacheValue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found controller in request, locating layout for controller [{}] and action [{}}]", (Object)controllerName, (Object)actionUri);
                        }
                        LayoutCacheKey cacheKey = null;
                        boolean cachedIsNull = false;
                        if (!(!this.cacheEnabled || (cacheValue = this.layoutDecoratorCache.get(cacheKey = new LayoutCacheKey(controllerName, actionUri))) == null || this.gspReloadEnabled && cacheValue.isExpired() || (d = cacheValue.getDecorator()) != null)) {
                            cachedIsNull = true;
                        }
                        if (d == null && !cachedIsNull) {
                            d = this.resolveDecorator(request, controller, controllerName, actionUri);
                            if (this.cacheEnabled) {
                                if (LOG.isDebugEnabled() && d != null) {
                                    LOG.debug("Caching resolved layout {} for controller {} and action {}", new Object[]{d.getPage(), controllerName, actionUri});
                                }
                                this.layoutDecoratorCache.put(cacheKey, new DecoratorCacheValue(d));
                            }
                        }
                    }
                } else {
                    d = this.getApplicationDefaultDecorator(request);
                }
            } else {
                d = this.getNamedDecorator(request, layoutName);
            }
            if (d != null) {
                return d;
            }
        }
        return null;
    }

    protected Decorator getApplicationDefaultDecorator(HttpServletRequest request) {
        return this.getNamedDecorator(request, this.defaultDecoratorName == null ? "application" : this.defaultDecoratorName, !this.enableNonGspViews || this.defaultDecoratorName == null);
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        return this.getNamedDecorator(request, name, !this.enableNonGspViews);
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name, boolean viewMustExist) {
        View view;
        DecoratorCacheValue cacheValue;
        if (GrailsStringUtils.isBlank((String)name) || "_none_".equals(name)) {
            return null;
        }
        if (!(!this.cacheEnabled || (cacheValue = this.decoratorCache.get(name)) == null || this.gspReloadEnabled && cacheValue.isExpired())) {
            return cacheValue.getDecorator();
        }
        try {
            view = this.viewResolver.resolveViewName(GrailsResourceUtils.cleanPath((String)GrailsResourceUtils.appendPiecesForUri((String[])new String[]{LAYOUTS_PATH, name})), request.getLocale());
            if (viewMustExist && !(view instanceof AbstractGrailsView)) {
                view = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve view", e);
        }
        Decorator d = null;
        if (view != null) {
            d = this.createDecorator(name, view);
        }
        if (this.cacheEnabled) {
            this.decoratorCache.put(name, new DecoratorCacheValue(d));
        }
        return d;
    }

    private Decorator resolveDecorator(HttpServletRequest request, GroovyObject controller, String controllerName, String actionUri) {
        Decorator d = null;
        Object layoutProperty = GrailsClassUtils.getStaticPropertyValue(controller.getClass(), (String)"layout");
        if (layoutProperty instanceof CharSequence) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("layout property found in controller, looking for template named {}", layoutProperty);
            }
            d = this.getNamedDecorator(request, layoutProperty.toString());
        } else {
            if (!GrailsStringUtils.isBlank((String)actionUri)) {
                d = this.getNamedDecorator(request, actionUri.substring(1), true);
            }
            if (d == null && !GrailsStringUtils.isBlank((String)controllerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Action layout not found, trying controller");
                }
                d = this.getNamedDecorator(request, controllerName, true);
            }
            if (d == null) {
                d = this.getApplicationDefaultDecorator(request);
            }
        }
        return d;
    }

    private Decorator createDecorator(String decoratorName, View view) {
        return new SpringMVCViewDecorator(decoratorName, view);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!(this.viewResolver instanceof GrailsViewResolver)) {
            this.setViewResolver((ViewResolver)event.getApplicationContext().getBean(GrailsViewResolver.class));
        }
    }

    private static class LayoutCacheKey {
        private String controllerName;
        private String actionUri;

        public LayoutCacheKey(String controllerName, String actionUri) {
            this.controllerName = controllerName;
            this.actionUri = actionUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutCacheKey that = (LayoutCacheKey)o;
            if (!this.actionUri.equals(that.actionUri)) {
                return false;
            }
            return this.controllerName.equals(that.controllerName);
        }

        public int hashCode() {
            int result = this.controllerName.hashCode();
            result = 31 * result + this.actionUri.hashCode();
            return result;
        }
    }

    private static class DecoratorCacheValue {
        Decorator decorator;
        long createTimestamp = System.currentTimeMillis();

        public DecoratorCacheValue(Decorator decorator) {
            this.decorator = decorator;
        }

        public Decorator getDecorator() {
            return this.decorator;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createTimestamp > LAYOUT_CACHE_EXPIRATION_MILLIS;
        }
    }
}

