/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints.builder;

import grails.gorm.validation.ConstrainedProperty;
import grails.gorm.validation.Constraint;
import grails.gorm.validation.DefaultConstrainedProperty;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.util.BuilderSupport;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.validation.constraints.eval.DefaultConstraintEvaluator;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.InvalidPropertyException;

public class ConstrainedPropertyBuilder
extends BuilderSupport {
    private static final String SHARED_CONSTRAINT = "shared";
    private static final String IMPORT_FROM_CONSTRAINT = "importFrom";
    private static final Logger LOG = LoggerFactory.getLogger(ConstrainedPropertyBuilder.class);
    private final Map<String, ConstrainedProperty> constrainedProperties = new LinkedHashMap<String, ConstrainedProperty>();
    private final Map<String, String> sharedConstraints = new HashMap<String, String>();
    private int order = 1;
    private final Class<?> targetClass;
    private final ClassPropertyFetcher classPropertyFetcher;
    private final MetaClass targetMetaClass;
    private final ConstraintRegistry constraintRegistry;
    private final MappingContext mappingContext;
    private final Map<String, Object> defaultConstraints;
    private boolean allowDynamic = false;
    private boolean defaultNullable = false;

    public ConstrainedPropertyBuilder(MappingContext mappingContext, ConstraintRegistry constraintRegistry, Class targetClass, Map<String, Object> defaultConstraints) {
        this.targetClass = targetClass;
        this.mappingContext = mappingContext;
        this.classPropertyFetcher = ClassPropertyFetcher.forClass((Class)targetClass);
        this.targetMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(targetClass);
        this.constraintRegistry = constraintRegistry;
        this.defaultConstraints = defaultConstraints;
    }

    public String getSharedConstraint(String propertyName) {
        return this.sharedConstraints.get(propertyName);
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        try {
            return super.doInvokeMethod(methodName, name, args);
        }
        catch (MissingMethodException e) {
            return this.targetMetaClass.invokeMethod(this.targetClass, methodName, args);
        }
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.targetMetaClass.getProperty(this.targetClass, property);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.targetMetaClass.setProperty(this.targetClass, property, newValue);
        }
    }

    protected Class<?> determinePropertyType(String propertyName) {
        PersistentProperty persistentProperty;
        Class propertyType = null;
        PersistentEntity persistentEntity = this.mappingContext.getPersistentEntity(this.targetClass.getName());
        if (persistentEntity != null && (persistentProperty = persistentEntity.getPropertyByName(propertyName)) != null) {
            propertyType = persistentProperty.getType();
        }
        if (propertyType == null) {
            propertyType = this.classPropertyFetcher.getPropertyType(propertyName);
        }
        return propertyType;
    }

    protected Object createNode(Object name, Map attributes) {
        try {
            DefaultConstrainedProperty cp;
            String property = (String)name;
            if (this.constrainedProperties.containsKey(property)) {
                cp = (DefaultConstrainedProperty)this.constrainedProperties.get(property);
            } else {
                Class<Object> propertyType = this.determinePropertyType(property);
                if (propertyType == null) {
                    if (!this.allowDynamic) {
                        throw new MissingMethodException(property, this.targetClass, new Object[]{attributes}, true);
                    }
                    propertyType = CharSequence.class;
                }
                cp = new DefaultConstrainedProperty(this.targetClass, property, propertyType, this.constraintRegistry);
                cp.setOrder(this.order++);
                this.constrainedProperties.put(property, cp);
            }
            if (cp.getPropertyType() == null) {
                if (!IMPORT_FROM_CONSTRAINT.equals(name)) {
                    LOG.warn("Property [" + cp.getPropertyName() + "] not found in domain class " + this.targetClass.getName() + "; cannot apply constraints: " + String.valueOf(attributes));
                }
                return cp;
            }
            for (Object o : attributes.keySet()) {
                String constraintName = (String)o;
                Object value = attributes.get(constraintName);
                if (SHARED_CONSTRAINT.equals(constraintName)) {
                    if (value == null) continue;
                    this.sharedConstraints.put(property, value.toString());
                    continue;
                }
                if (cp.supportsContraint(constraintName)) {
                    cp.applyConstraint(constraintName, value);
                    continue;
                }
                if (!this.constraintRegistry.findConstraintFactories(constraintName).isEmpty()) {
                    LOG.warn("Property [" + cp.getPropertyName() + "] of domain class " + this.targetClass.getName() + " has type [" + cp.getPropertyType().getName() + "] and doesn't support constraint [" + constraintName + "]. This constraint will not be checked during validation.");
                    continue;
                }
                cp.addMetaConstraint(constraintName, value);
            }
            return cp;
        }
        catch (InvalidPropertyException ipe) {
            throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes});
        }
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        if (IMPORT_FROM_CONSTRAINT.equals(name) && value instanceof Class) {
            return this.handleImportFrom(attributes, (Class)value);
        }
        throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes, value});
    }

    private Object handleImportFrom(Map attributes, Class importFromClazz) {
        Map<String, ConstrainedProperty> importFromConstrainedProperties = new DefaultConstraintEvaluator(this.constraintRegistry, this.mappingContext, this.defaultConstraints).evaluate(importFromClazz, this.defaultNullable);
        List metaProperties = this.classPropertyFetcher.getMetaProperties();
        List toBeIncludedPropertyNamesParam = (List)attributes.get("include");
        List toBeExcludedPropertyNamesParam = (List)attributes.get("exclude");
        ArrayList<String> resultingPropertyNames = new ArrayList<String>();
        for (MetaProperty metaProperty : metaProperties) {
            if (Modifier.isStatic(metaProperty.getModifiers())) continue;
            String propertyName = metaProperty.getName();
            if (toBeIncludedPropertyNamesParam == null) {
                resultingPropertyNames.add(propertyName);
            } else if (this.isListOfRegexpsContainsString(toBeIncludedPropertyNamesParam, propertyName)) {
                resultingPropertyNames.add(propertyName);
            }
            if (toBeExcludedPropertyNamesParam == null || !this.isListOfRegexpsContainsString(toBeExcludedPropertyNamesParam, propertyName)) continue;
            resultingPropertyNames.remove(propertyName);
        }
        resultingPropertyNames.remove("class");
        resultingPropertyNames.remove("metaClass");
        for (String targetPropertyName : resultingPropertyNames) {
            DefaultConstrainedProperty importFromConstrainedProperty = (DefaultConstrainedProperty)importFromConstrainedProperties.get(targetPropertyName);
            if (importFromConstrainedProperty == null) continue;
            HashMap<String, Object> importFromConstrainedPropertyAttributes = new HashMap<String, Object>();
            for (Constraint importFromAppliedConstraint : importFromConstrainedProperty.getAppliedConstraints()) {
                String importFromAppliedConstraintName = importFromAppliedConstraint.getName();
                Object importFromAppliedConstraintParameter = importFromAppliedConstraint.getParameter();
                importFromConstrainedPropertyAttributes.put(importFromAppliedConstraintName, importFromAppliedConstraintParameter);
            }
            importFromConstrainedPropertyAttributes.putAll(importFromConstrainedProperty.getMetaConstraints());
            this.createNode((Object)targetPropertyName, importFromConstrainedPropertyAttributes);
        }
        return null;
    }

    private boolean isListOfRegexpsContainsString(List<String> listOfStrings, String stringToMatch) {
        boolean result = false;
        for (String listElement : listOfStrings) {
            if (!stringToMatch.matches(listElement)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    public Map<String, ConstrainedProperty> getConstrainedProperties() {
        return this.constrainedProperties;
    }

    public void setAllowDynamic(boolean allowDynamic) {
        this.allowDynamic = allowDynamic;
    }

    public void setDefaultNullable(boolean defaultNullable) {
        this.defaultNullable = defaultNullable;
    }
}

