/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class MinConstraint
extends AbstractConstraint {
    private final Comparable minValue;

    public MinConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.minValue = (Comparable)this.constraintParameter;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (Comparable.class.isAssignableFrom(type) || ClassUtils.isAssignableOrConvertibleFrom(Number.class, (Class)type));
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (constraintParameter == null) {
            throw new IllegalArgumentException("Parameter for constraint [min] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] cannot be null");
        }
        if (!(constraintParameter instanceof Comparable) && !constraintParameter.getClass().isPrimitive()) {
            throw new IllegalArgumentException("Parameter for constraint [min] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must implement the interface [java.lang.Comparable]");
        }
        Class propertyClass = ClassPropertyFetcher.getPropertyType((Class)this.constraintOwningClass, (String)this.constraintPropertyName);
        if (!ClassUtils.isAssignableOrConvertibleFrom(constraintParameter.getClass(), (Class)propertyClass)) {
            throw new IllegalArgumentException("Parameter for constraint [min] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be the same type as property: [" + propertyClass.getName() + "]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.minValue.compareTo(propertyValue) <= 0) {
            return;
        }
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.minValue};
        this.rejectValue(target, errors, "default.invalid.min.message", "min.notmet", args);
    }
}

