/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class MaxConstraint
extends AbstractConstraint {
    private final Comparable maxValue;

    public MaxConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.maxValue = (Comparable)this.constraintParameter;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (Comparable.class.isAssignableFrom(type) || ClassUtils.isAssignableOrConvertibleFrom(Number.class, (Class)type));
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (constraintParameter == null) {
            throw new IllegalArgumentException("Parameter for constraint [max] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] cannot be null");
        }
        if (!(constraintParameter instanceof Comparable) && !constraintParameter.getClass().isPrimitive()) {
            throw new IllegalArgumentException("Parameter for constraint [max] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must implement the interface [java.lang.Comparable]");
        }
        Class propertyClass = ClassPropertyFetcher.getPropertyType((Class)this.constraintOwningClass, (String)this.constraintPropertyName);
        if (!ClassUtils.isAssignableOrConvertibleFrom(constraintParameter.getClass(), (Class)propertyClass)) {
            throw new IllegalArgumentException("Parameter for constraint [max] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be the same type as property: [" + propertyClass.getName() + "]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "max";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.maxValue.compareTo(propertyValue) < 0) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.maxValue};
            this.rejectValue(target, errors, "default.invalid.max.message", "max.exceeded", args);
        }
    }
}

