/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.json;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;
import org.bson.AbstractBsonWriter;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriterSettings;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class JsonWriter
extends AbstractBsonWriter {
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mmZ";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected final Writer writer;
    protected final JsonWriterSettings settings;

    public JsonWriter(Writer target) {
        this(target, JsonWriterSettings.builder().build());
    }

    public JsonWriter(Writer target, JsonWriterSettings settings) {
        super((BsonWriterSettings)settings);
        this.writer = target;
        this.settings = settings;
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL, ""));
    }

    protected void doWriteStartDocument() {
        try {
            if (this.getState() == AbstractBsonWriter.State.VALUE || this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT) {
                this.writeNameHelper(this.getName());
            }
            BsonContextType contextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
            this.setContext(new Context(this.getContext(), contextType, this.settings.getIndentCharacters()));
            this.writer.write(123);
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteEndDocument() {
        try {
            this.writer.write(125);
            if (this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
                this.setContext(this.getContext().getParentContext());
                this.writeEndDocument();
            } else {
                this.setContext(this.getContext().getParentContext());
            }
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteStartArray() {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(91);
            this.setContext(new Context(this.getContext(), BsonContextType.ARRAY, this.settings.getIndentCharacters()));
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteEndArray() {
        try {
            this.writer.write(93);
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
        this.setContext(this.getContext().getParentContext());
    }

    protected void doWriteBinaryData(BsonBinary value) {
        try {
            this.writeNameHelper(this.getName());
            byte[] data = value.getData();
            this.writer.write(Base64.getEncoder().encodeToString(data));
            this.setState(this.getNextState());
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteBoolean(boolean value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(value ? "true" : "false");
            this.setState(this.getNextState());
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteDateTime(long value) {
        SimpleDateFormat df = new SimpleDateFormat(ISO_8601);
        df.setTimeZone(UTC);
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(34);
            Date date = new Date(value);
            this.writer.write(df.format(date));
            this.writer.write(34);
            this.setState(this.getNextState());
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteDBPointer(BsonDbPointer value) {
    }

    protected void doWriteDouble(double value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(Double.toString(value));
            this.setState(this.getNextState());
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteInt32(int value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(Integer.toString(value));
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteInt64(long value) {
        try {
            this.writeNameHelper(this.getName());
            if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                this.writer.write(Long.toString(value));
            } else {
                this.writer.write(34);
                this.writer.write(Long.toString(value));
                this.writer.write(34);
            }
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteDecimal128(Decimal128 value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(34);
            this.writer.write(value.toString());
            this.writer.write(34);
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteJavaScript(String value) {
    }

    protected void doWriteJavaScriptWithScope(String value) {
    }

    protected void doWriteMaxKey() {
    }

    protected void doWriteMinKey() {
    }

    protected void doWriteNull() {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write("null");
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteObjectId(ObjectId value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(value.toString());
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteRegularExpression(BsonRegularExpression regularExpression) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeString("$regex", regularExpression.getPattern());
                    this.writeString("$options", regularExpression.getOptions());
                    this.writeEndDocument();
                    break;
                }
                default: {
                    this.writeNameHelper(this.getName());
                    this.writer.write(47);
                    String escaped = regularExpression.getPattern().equals("") ? "(?:)" : regularExpression.getPattern().replace("/", "\\/");
                    this.writer.write(escaped);
                    this.writer.write(47);
                    this.writer.write(regularExpression.getOptions());
                    break;
                }
            }
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteString(String value) {
        try {
            this.writeNameHelper(this.getName());
            this.writeStringHelper(value);
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void doWriteSymbol(String value) {
    }

    protected void doWriteTimestamp(BsonTimestamp value) {
    }

    protected void doWriteUndefined() {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write("undefined");
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            this.throwBsonException(e);
        }
    }

    protected void writeNameHelper(String name) throws IOException {
        switch (this.getContext().getContextType()) {
            case ARRAY: {
                if (!this.getContext().hasElements) break;
                this.writer.write(44);
                break;
            }
            case DOCUMENT: 
            case SCOPE_DOCUMENT: {
                if (this.getContext().hasElements) {
                    this.writer.write(44);
                }
                if (this.settings.isIndent()) {
                    this.writer.write(this.settings.getNewLineCharacters());
                    this.writer.write(this.getContext().indentation);
                }
                this.writeStringHelper(name);
                this.writer.write(58);
                break;
            }
            case TOP_LEVEL: {
                break;
            }
            default: {
                throw new BSONException("Invalid contextType.");
            }
        }
        this.getContext().hasElements = true;
    }

    private void throwBsonException(IOException e) {
        throw new BSONException("Cannot write to writer writer: " + e.getMessage(), (Throwable)e);
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    private void writeStringHelper(String str) throws IOException {
        this.writer.write(34);
        block12: for (char c : str.toCharArray()) {
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block12;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block12;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block12;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block12;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block12;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block12;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block12;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            this.writer.write(c);
                            continue block12;
                        }
                    }
                    this.writer.write("\\u");
                    this.writer.write(Integer.toHexString((c & 0xF000) >> 12));
                    this.writer.write(Integer.toHexString((c & 0xF00) >> 8));
                    this.writer.write(Integer.toHexString((c & 0xF0) >> 4));
                    this.writer.write(Integer.toHexString(c & 0xF));
                }
            }
        }
        this.writer.write(34);
    }

    public class Context
    extends AbstractBsonWriter.Context {
        private final String indentation;
        private boolean hasElements;

        public Context(Context parentContext, BsonContextType contextType, String indentChars) {
            super((AbstractBsonWriter)JsonWriter.this, (AbstractBsonWriter.Context)parentContext, contextType);
            this.indentation = parentContext == null ? indentChars : parentContext.indentation + indentChars;
        }

        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

