/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.json;

import org.grails.datastore.bson.json.JsonTokenType;

class JsonToken {
    static final String BOOLEAN_TRUE = "true";
    static final String BOOLEAN_FALSE = "false";
    static final String NULL = "null";
    static final char FORWARD_SLASH = '/';
    static final char BACK_SLASH = '\\';
    static final char MINUS = '-';
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    static final char OPEN_PARENS = '(';
    static final char CLOSE_PARENS = ')';
    static final char OPEN_BRACE = '{';
    static final char CLOSE_BRACE = '}';
    static final char COLON = ':';
    static final char COMMA = ',';
    static final char SPACE = ' ';
    static final char NEW_LINE = '\n';
    static final char QUOTE = '\"';
    private final Object value;
    private final JsonTokenType type;

    public JsonToken(JsonTokenType type, Object value) {
        this.value = value;
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> clazz) {
        if (Long.class == clazz) {
            if (this.value instanceof Integer) {
                return clazz.cast(((Integer)this.value).longValue());
            }
            if (this.value instanceof String) {
                return clazz.cast(Long.valueOf((String)this.value));
            }
        }
        try {
            return clazz.cast(this.value);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    public JsonTokenType getType() {
        return this.type;
    }
}

