/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.json;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.bson.BsonRegularExpression;
import org.bson.json.JsonParseException;
import org.grails.datastore.bson.json.JsonToken;
import org.grails.datastore.bson.json.JsonTokenType;

class JsonScanner {
    private static final char[] NFINITY = new char[]{'n', 'f', 'i', 'n', 'i', 't', 'y'};
    final PushbackReader reader;
    int position;

    public JsonScanner(Reader reader) {
        this.reader = new PushbackReader(reader);
    }

    public JsonToken nextToken() throws IOException {
        int c = this.readCharacter();
        while (c != -1 && Character.isWhitespace(c)) {
            c = this.readCharacter();
        }
        if (c == -1) {
            return new JsonToken(JsonTokenType.END_OF_FILE, "<eof>");
        }
        switch (c) {
            case 123: {
                return new JsonToken(JsonTokenType.BEGIN_OBJECT, Character.valueOf('{'));
            }
            case 125: {
                return new JsonToken(JsonTokenType.END_OBJECT, Character.valueOf('}'));
            }
            case 91: {
                return new JsonToken(JsonTokenType.BEGIN_ARRAY, Character.valueOf('['));
            }
            case 93: {
                return new JsonToken(JsonTokenType.END_ARRAY, Character.valueOf(']'));
            }
            case 40: {
                return new JsonToken(JsonTokenType.LEFT_PAREN, Character.valueOf('('));
            }
            case 41: {
                return new JsonToken(JsonTokenType.RIGHT_PAREN, Character.valueOf(')'));
            }
            case 58: {
                return new JsonToken(JsonTokenType.COLON, Character.valueOf(']'));
            }
            case 44: {
                return new JsonToken(JsonTokenType.COMMA, Character.valueOf(','));
            }
            case 34: 
            case 92: {
                return this.scanString((char)c);
            }
            case 47: {
                return this.scanRegularExpression();
            }
        }
        if (c == 45 || Character.isDigit(c)) {
            return this.scanNumber((char)c);
        }
        if (c == 36 || c == 95 || Character.isLetter(c)) {
            return this.scanUnquotedString((char)c);
        }
        this.reader.unread(c);
        throw new JsonParseException("Invalid JSON input. Position: %d. Character: '%c'.", new Object[]{this.position, c});
    }

    protected int readCharacter() throws IOException {
        ++this.position;
        return this.reader.read();
    }

    private JsonToken scanRegularExpression() throws IOException {
        RegularExpressionState state = RegularExpressionState.IN_PATTERN;
        StringBuilder optionsBuilder = new StringBuilder();
        StringBuilder regexBuilder = new StringBuilder();
        while (true) {
            int c = this.readCharacter();
            block0 : switch (state) {
                case IN_PATTERN: {
                    switch (c) {
                        case 47: {
                            state = RegularExpressionState.IN_OPTIONS;
                            break block0;
                        }
                        case 92: {
                            state = RegularExpressionState.IN_ESCAPE_SEQUENCE;
                            regexBuilder.append((char)c);
                            break block0;
                        }
                    }
                    state = RegularExpressionState.IN_PATTERN;
                    regexBuilder.append((char)c);
                    break;
                }
                case IN_ESCAPE_SEQUENCE: {
                    state = RegularExpressionState.IN_PATTERN;
                    regexBuilder.append((char)c);
                    break;
                }
                case IN_OPTIONS: {
                    switch (c) {
                        case 105: 
                        case 109: 
                        case 115: 
                        case 120: {
                            state = RegularExpressionState.IN_OPTIONS;
                            optionsBuilder.append((char)c);
                            break block0;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            state = RegularExpressionState.DONE;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        state = RegularExpressionState.DONE;
                        break;
                    }
                    state = RegularExpressionState.INVALID;
                    break;
                }
            }
            switch (state) {
                case DONE: {
                    this.reader.unread(c);
                    BsonRegularExpression regex = new BsonRegularExpression(regexBuilder.toString(), optionsBuilder.toString());
                    return new JsonToken(JsonTokenType.REGULAR_EXPRESSION, regex);
                }
                case INVALID: {
                    throw new JsonParseException("Invalid JSON regular expression. Position: %d.", new Object[]{this.position});
                }
            }
        }
    }

    private JsonToken scanUnquotedString(char startChar) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(startChar);
        int c = this.readCharacter();
        while (c == 36 || c == 95 || Character.isLetterOrDigit(c)) {
            builder.append((char)c);
            c = this.readCharacter();
        }
        this.reader.unread(c);
        String lexeme = builder.toString();
        return new JsonToken(JsonTokenType.UNQUOTED_STRING, lexeme);
    }

    private JsonToken scanNumber(char firstChar) throws IOException {
        int c = firstChar;
        StringBuilder numberBuilder = new StringBuilder();
        numberBuilder.append((char)firstChar);
        NumberState state = switch (c) {
            case 45 -> NumberState.SAW_LEADING_MINUS;
            case 48 -> NumberState.SAW_LEADING_ZERO;
            default -> NumberState.SAW_INTEGER_DIGITS;
        };
        JsonTokenType type = JsonTokenType.INT64;
        while (true) {
            c = this.readCharacter();
            block4 : switch (state) {
                case SAW_LEADING_MINUS: {
                    switch (c) {
                        case 48: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_LEADING_ZERO;
                            break block4;
                        }
                        case 73: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_MINUS_I;
                            break block4;
                        }
                    }
                    numberBuilder.append((char)c);
                    if (Character.isDigit(c)) {
                        state = NumberState.SAW_INTEGER_DIGITS;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_LEADING_ZERO: 
                case SAW_INTEGER_DIGITS: {
                    switch (c) {
                        case 46: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_DECIMAL_POINT;
                            break block4;
                        }
                        case 69: 
                        case 101: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_EXPONENT_LETTER;
                            break block4;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            state = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_INTEGER_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = NumberState.DONE;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_DECIMAL_POINT: {
                    type = JsonTokenType.DOUBLE;
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_FRACTION_DIGITS;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_FRACTION_DIGITS: {
                    switch (c) {
                        case 69: 
                        case 101: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_EXPONENT_LETTER;
                            break block4;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            state = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_FRACTION_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = NumberState.DONE;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_LETTER: {
                    type = JsonTokenType.DOUBLE;
                    switch (c) {
                        case 43: 
                        case 45: {
                            numberBuilder.append((char)c);
                            state = NumberState.SAW_EXPONENT_SIGN;
                            break block4;
                        }
                    }
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_SIGN: {
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_DIGITS: {
                    switch (c) {
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            state = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(c)) {
                        numberBuilder.append((char)c);
                        state = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = NumberState.DONE;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
                case SAW_MINUS_I: {
                    boolean sawMinusInfinity = true;
                    numberBuilder.append((char)c);
                    for (int i = 0; i < NFINITY.length; ++i) {
                        if (c != NFINITY[i]) {
                            sawMinusInfinity = false;
                            break;
                        }
                        c = this.readCharacter();
                        numberBuilder.append((char)c);
                    }
                    if (sawMinusInfinity) {
                        type = JsonTokenType.DOUBLE;
                        switch (c) {
                            case -1: 
                            case 41: 
                            case 44: 
                            case 93: 
                            case 125: {
                                state = NumberState.DONE;
                                break block4;
                            }
                        }
                        if (Character.isWhitespace(c)) {
                            state = NumberState.DONE;
                            break;
                        }
                        state = NumberState.INVALID;
                        break;
                    }
                    state = NumberState.INVALID;
                    break;
                }
            }
            switch (state) {
                case INVALID: {
                    throw new JsonParseException("Invalid JSON number");
                }
                case DONE: {
                    this.reader.unread(c);
                    if (type == JsonTokenType.DOUBLE) {
                        return new JsonToken(JsonTokenType.DOUBLE, Double.parseDouble(numberBuilder.toString()));
                    }
                    long value = Long.parseLong(numberBuilder.toString());
                    if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                        return new JsonToken(JsonTokenType.INT64, value);
                    }
                    return new JsonToken(JsonTokenType.INT32, (int)value);
                }
            }
        }
    }

    private JsonToken scanString(char quoteCharacter) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        block15: do {
            c = this.readCharacter();
            block0 : switch (c) {
                case 92: {
                    c = this.readCharacter();
                    switch (c) {
                        case 39: {
                            sb.append('\'');
                            break block0;
                        }
                        case 34: {
                            sb.append('\"');
                            break block0;
                        }
                        case 92: {
                            sb.append('\\');
                            break block0;
                        }
                        case 47: {
                            sb.append('/');
                            break block0;
                        }
                        case 98: {
                            sb.append('\b');
                            break block0;
                        }
                        case 102: {
                            sb.append('\f');
                            break block0;
                        }
                        case 110: {
                            sb.append('\n');
                            break block0;
                        }
                        case 114: {
                            sb.append('\r');
                            break block0;
                        }
                        case 116: {
                            sb.append('\t');
                            break block0;
                        }
                        case 117: {
                            int u1 = this.readCharacter();
                            int u2 = this.readCharacter();
                            int u3 = this.readCharacter();
                            int u4 = this.readCharacter();
                            if (u4 == -1) continue block15;
                            String hex = new String(new char[]{(char)u1, (char)u2, (char)u3, (char)u4});
                            sb.append((char)Integer.parseInt(hex, 16));
                            break block0;
                        }
                        default: {
                            throw new JsonParseException("Invalid escape sequence in JSON string '\\%c'.", new Object[]{c});
                        }
                    }
                }
                default: {
                    if (c == quoteCharacter) {
                        return new JsonToken(JsonTokenType.STRING, sb.toString());
                    }
                    if (c == -1) continue block15;
                    sb.append((char)c);
                }
            }
        } while (c != -1);
        throw new JsonParseException("End of file in JSON string.");
    }

    private static enum RegularExpressionState {
        IN_PATTERN,
        IN_ESCAPE_SEQUENCE,
        IN_OPTIONS,
        DONE,
        INVALID;

    }

    private static enum NumberState {
        SAW_LEADING_MINUS,
        SAW_LEADING_ZERO,
        SAW_INTEGER_DIGITS,
        SAW_DECIMAL_POINT,
        SAW_FRACTION_DIGITS,
        SAW_EXPONENT_LETTER,
        SAW_EXPONENT_SIGN,
        SAW_EXPONENT_DIGITS,
        SAW_MINUS_I,
        DONE,
        INVALID;

    }
}

