/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReaderMark;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.json.JsonParseException;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.grails.datastore.bson.json.JsonScanner;
import org.grails.datastore.bson.json.JsonToken;
import org.grails.datastore.bson.json.JsonTokenType;

public class JsonReader
extends AbstractBsonReader {
    private final JsonScanner scanner;
    private JsonToken pushedToken;
    private Object currentValue;
    private Mark mark;

    public JsonReader(String json) {
        this(new StringReader(json));
    }

    public JsonReader(Reader reader) {
        this.scanner = new JsonScanner(reader);
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL));
    }

    protected BsonBinary doReadBinaryData() {
        return (BsonBinary)this.currentValue;
    }

    protected byte doPeekBinarySubType() {
        return this.doReadBinaryData().getType();
    }

    protected int doPeekBinarySize() {
        return this.doReadBinaryData().getData().length;
    }

    protected boolean doReadBoolean() {
        return (Boolean)this.currentValue;
    }

    public BsonType readBsonType() {
        JsonToken commaToken;
        if (this.isClosed()) {
            throw new IllegalStateException("This instance has been closed");
        }
        if (this.getState() == AbstractBsonReader.State.INITIAL || this.getState() == AbstractBsonReader.State.DONE || this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT) {
            this.setState(AbstractBsonReader.State.TYPE);
        }
        if (this.getState() != AbstractBsonReader.State.TYPE) {
            this.throwInvalidState("readBSONType", new AbstractBsonReader.State[]{AbstractBsonReader.State.TYPE});
        }
        if (this.getContext().getContextType() == BsonContextType.DOCUMENT) {
            JsonToken nameToken = this.popToken();
            switch (nameToken.getType()) {
                case STRING: 
                case UNQUOTED_STRING: {
                    this.setCurrentName(nameToken.getValue(String.class));
                    break;
                }
                case END_OBJECT: {
                    this.setState(AbstractBsonReader.State.END_OF_DOCUMENT);
                    return BsonType.END_OF_DOCUMENT;
                }
                default: {
                    throw new JsonParseException("JSON reader was expecting a name but found '%s'.", new Object[]{nameToken.getValue()});
                }
            }
            JsonToken colonToken = this.popToken();
            if (colonToken.getType() != JsonTokenType.COLON) {
                throw new JsonParseException("JSON reader was expecting ':' but found '%s'.", new Object[]{colonToken.getValue()});
            }
        }
        JsonToken token = this.popToken();
        if (this.getContext().getContextType() == BsonContextType.ARRAY && token.getType() == JsonTokenType.END_ARRAY) {
            this.setState(AbstractBsonReader.State.END_OF_ARRAY);
            return BsonType.END_OF_DOCUMENT;
        }
        boolean noValueFound = false;
        switch (token.getType()) {
            case BEGIN_ARRAY: {
                this.setCurrentBsonType(BsonType.ARRAY);
                break;
            }
            case BEGIN_OBJECT: {
                this.visitExtendedJSON();
                break;
            }
            case DOUBLE: {
                this.setCurrentBsonType(BsonType.DOUBLE);
                this.currentValue = token.getValue();
                break;
            }
            case END_OF_FILE: {
                this.setCurrentBsonType(BsonType.END_OF_DOCUMENT);
                break;
            }
            case INT32: {
                this.setCurrentBsonType(BsonType.INT32);
                this.currentValue = token.getValue();
                break;
            }
            case INT64: {
                this.setCurrentBsonType(BsonType.INT64);
                this.currentValue = token.getValue();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                this.currentValue = token.getValue();
                break;
            }
            case STRING: {
                this.setCurrentBsonType(BsonType.STRING);
                this.currentValue = token.getValue();
                break;
            }
            case UNQUOTED_STRING: {
                String value = token.getValue(String.class);
                if ("false".equals(value) || "true".equals(value)) {
                    this.setCurrentBsonType(BsonType.BOOLEAN);
                    this.currentValue = Boolean.parseBoolean(value);
                    break;
                }
                if ("Infinity".equals(value)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.POSITIVE_INFINITY;
                    break;
                }
                if ("NaN".equals(value)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.NaN;
                    break;
                }
                if ("null".equals(value)) {
                    this.setCurrentBsonType(BsonType.NULL);
                    break;
                }
                if ("undefined".equals(value)) {
                    this.setCurrentBsonType(BsonType.UNDEFINED);
                    break;
                }
                noValueFound = true;
                break;
            }
            default: {
                noValueFound = true;
            }
        }
        if (noValueFound) {
            throw new JsonParseException("JSON reader was expecting a value but found '%s'.", new Object[]{token.getValue()});
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
        switch (this.getContext().getContextType()) {
            default: {
                this.setState(AbstractBsonReader.State.NAME);
                break;
            }
            case ARRAY: 
            case JAVASCRIPT_WITH_SCOPE: 
            case TOP_LEVEL: {
                this.setState(AbstractBsonReader.State.VALUE);
            }
        }
        return this.getCurrentBsonType();
    }

    protected long doReadDateTime() {
        return (Long)this.currentValue;
    }

    protected double doReadDouble() {
        return (Double)this.currentValue;
    }

    protected void doReadEndArray() {
        JsonToken commaToken;
        this.setContext(this.getContext().getParentContext());
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
    }

    protected void doReadEndDocument() {
        JsonToken commaToken;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext() != null && this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
            this.setContext(this.getContext().getParentContext());
            this.verifyToken(Character.valueOf('}'));
        }
        if (this.getContext() == null) {
            throw new JsonParseException("Unexpected end of document.");
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
    }

    protected int doReadInt32() {
        return (Integer)this.currentValue;
    }

    protected long doReadInt64() {
        return (Long)this.currentValue;
    }

    protected Decimal128 doReadDecimal128() {
        return Decimal128.parse((String)this.currentValue.toString());
    }

    protected String doReadJavaScript() {
        return (String)this.currentValue;
    }

    protected String doReadJavaScriptWithScope() {
        return (String)this.currentValue;
    }

    protected void doReadMaxKey() {
    }

    protected void doReadMinKey() {
    }

    protected void doReadNull() {
    }

    protected ObjectId doReadObjectId() {
        return (ObjectId)this.currentValue;
    }

    protected BsonRegularExpression doReadRegularExpression() {
        return (BsonRegularExpression)this.currentValue;
    }

    protected BsonDbPointer doReadDBPointer() {
        return (BsonDbPointer)this.currentValue;
    }

    protected void doReadStartArray() {
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    protected void doReadStartDocument() {
        this.setContext(new Context(this.getContext(), BsonContextType.DOCUMENT));
    }

    protected String doReadString() {
        return (String)this.currentValue;
    }

    protected String doReadSymbol() {
        return (String)this.currentValue;
    }

    protected BsonTimestamp doReadTimestamp() {
        return (BsonTimestamp)this.currentValue;
    }

    protected void doReadUndefined() {
    }

    protected void doSkipName() {
    }

    protected void doSkipValue() {
        switch (this.getCurrentBsonType()) {
            case ARRAY: {
                this.readStartArray();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipValue();
                }
                this.readEndArray();
                break;
            }
            case BINARY: {
                this.readBinaryData();
                break;
            }
            case BOOLEAN: {
                this.readBoolean();
                break;
            }
            case DATE_TIME: {
                this.readDateTime();
                break;
            }
            case DOCUMENT: {
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case DOUBLE: {
                this.readDouble();
                break;
            }
            case INT32: {
                this.readInt32();
                break;
            }
            case INT64: {
                this.readInt64();
                break;
            }
            case DECIMAL128: {
                this.readDecimal128();
                break;
            }
            case JAVASCRIPT: {
                this.readJavaScript();
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.readJavaScriptWithScope();
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case MAX_KEY: {
                this.readMaxKey();
                break;
            }
            case MIN_KEY: {
                this.readMinKey();
                break;
            }
            case NULL: {
                this.readNull();
                break;
            }
            case OBJECT_ID: {
                this.readObjectId();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.readRegularExpression();
                break;
            }
            case STRING: {
                this.readString();
                break;
            }
            case SYMBOL: {
                this.readSymbol();
                break;
            }
            case TIMESTAMP: {
                this.readTimestamp();
                break;
            }
            case UNDEFINED: {
                this.readUndefined();
                break;
            }
        }
    }

    private JsonToken popToken() {
        if (this.pushedToken != null) {
            JsonToken token = this.pushedToken;
            this.pushedToken = null;
            return token;
        }
        try {
            return this.scanner.nextToken();
        }
        catch (IOException e) {
            throw new JsonParseException("Cannot parse JSON due to IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void pushToken(JsonToken token) {
        if (this.pushedToken != null) {
            throw new BsonInvalidOperationException("There is already a pending token.");
        }
        this.pushedToken = token;
    }

    private void verifyToken(Object expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Can't be null");
        }
        JsonToken token = this.popToken();
        if (!expected.equals(token.getValue())) {
            throw new JsonParseException("JSON reader expected '%s' but found '%s'.", new Object[]{expected, token.getValue()});
        }
    }

    private void visitExtendedJSON() {
        JsonToken nameToken = this.popToken();
        this.pushToken(nameToken);
        this.setCurrentBsonType(BsonType.DOCUMENT);
    }

    public BsonReaderMark getMark() {
        return new Mark();
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    protected class Context
    extends AbstractBsonReader.Context {
        protected Context(AbstractBsonReader.Context parentContext, BsonContextType contextType) {
            super((AbstractBsonReader)JsonReader.this, parentContext, contextType);
        }

        protected Context getParentContext() {
            return (Context)super.getParentContext();
        }

        protected BsonContextType getContextType() {
            return super.getContextType();
        }
    }

    protected class Mark
    extends AbstractBsonReader.Mark {
        private JsonToken pushedToken;
        private Object currentValue;
        private int position;

        protected Mark() {
            super((AbstractBsonReader)JsonReader.this);
            this.pushedToken = JsonReader.this.pushedToken;
            this.currentValue = JsonReader.this.currentValue;
            this.position = JsonReader.this.scanner.position;
        }

        public void reset() {
            super.reset();
            JsonReader.this.pushedToken = this.pushedToken;
            JsonReader.this.currentValue = this.currentValue;
            try {
                JsonReader.this.scanner.reader.reset();
            }
            catch (IOException e) {
                throw new JsonParseException("Failed to reset reader: " + e.getMessage(), (Throwable)e);
            }
            JsonReader.this.setContext(new Context(this.getParentContext(), this.getContextType()));
            JsonReader.this.mark = null;
        }
    }
}

