/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.retry;

import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.exception.NonTransientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryerFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryerFactory.class);
    public static final String RETRY_MULTIPLIER = "multiplier";
    public static final String RETRY_INTERVAL_MS = "interval_ms";
    public static final String RETRY_TIME_OUT_MS = "time_out_ms";
    public static final String RETRY_TYPE = "retry_type";
    public static final String RETRY_TIMES = "retry_times";
    private static final Predicate<Throwable> RETRY_EXCEPTION_PREDICATE = t -> !(t instanceof NonTransientException);
    private static final Config DEFAULTS;

    public static <T> Retryer<T> newInstance(Config config, Optional<RetryListener> optRetryListener) {
        RetryerBuilder<T> builder;
        config = config.withFallback((ConfigMergeable)DEFAULTS);
        RetryType type = RetryType.valueOf(config.getString(RETRY_TYPE).toUpperCase());
        switch (type) {
            case EXPONENTIAL: {
                builder = RetryerFactory.newExponentialRetryerBuilder(config);
                break;
            }
            case FIXED: {
                builder = RetryerFactory.newFixedRetryerBuilder(config);
                break;
            }
            case FIXED_ATTEMPT: {
                builder = RetryerFactory.newFixedAttemptBoundRetryerBuilder(config);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)type) + " is not supported");
            }
        }
        optRetryListener.ifPresent(arg_0 -> builder.withRetryListener(arg_0));
        return builder.build();
    }

    public static <T> Retryer<T> newInstance(Config config) {
        return RetryerFactory.newInstance(config, Optional.empty());
    }

    private static <T> RetryerBuilder<T> newFixedRetryerBuilder(Config config) {
        return RetryerBuilder.newBuilder().retryIfException(RETRY_EXCEPTION_PREDICATE).withWaitStrategy(WaitStrategies.fixedWait((long)config.getLong(RETRY_INTERVAL_MS), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)config.getLong(RETRY_TIME_OUT_MS), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private static <T> RetryerBuilder<T> newExponentialRetryerBuilder(Config config) {
        return RetryerBuilder.newBuilder().retryIfException(RETRY_EXCEPTION_PREDICATE).withWaitStrategy(WaitStrategies.exponentialWait((long)config.getLong(RETRY_MULTIPLIER), (long)config.getLong(RETRY_INTERVAL_MS), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)config.getLong(RETRY_TIME_OUT_MS), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private static <T> RetryerBuilder<T> newFixedAttemptBoundRetryerBuilder(Config config) {
        return RetryerBuilder.newBuilder().retryIfException(RETRY_EXCEPTION_PREDICATE).withWaitStrategy(WaitStrategies.fixedWait((long)config.getLong(RETRY_INTERVAL_MS), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)config.getInt(RETRY_TIMES)));
    }

    static {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)RETRY_TIME_OUT_MS, (Object)TimeUnit.MINUTES.toMillis(5L)).put((Object)RETRY_INTERVAL_MS, (Object)TimeUnit.SECONDS.toMillis(30L)).put((Object)RETRY_MULTIPLIER, (Object)TimeUnit.SECONDS.toMillis(1L)).put((Object)RETRY_TYPE, (Object)RetryType.EXPONENTIAL.name()).put((Object)RETRY_TIMES, (Object)2).build();
        DEFAULTS = ConfigFactory.parseMap((Map)configMap);
    }

    public static enum RetryType {
        EXPONENTIAL,
        FIXED,
        FIXED_ATTEMPT;

    }
}

