/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.gobblin.util.request_allocation.HierarchicalPrioritizer;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.Requestor;

public class SimpleHierarchicalPrioritizer<T extends Request<T>>
implements HierarchicalPrioritizer<T>,
Serializable {
    private final Comparator<Requestor<T>> requestorComparator;
    private final Comparator<T> requestComparator;

    @Override
    public int compareRequestors(Requestor<T> r1, Requestor<T> r2) {
        return this.requestorComparator.compare(r1, r2);
    }

    @Override
    public int compare(T o1, T o2) {
        int requestorComparison = this.requestorComparator.compare(o1.getRequestor(), o2.getRequestor());
        if (requestorComparison != 0) {
            return requestorComparison;
        }
        return this.requestComparator.compare(o1, o2);
    }

    public SimpleHierarchicalPrioritizer(Comparator<Requestor<T>> requestorComparator, Comparator<T> requestComparator) {
        this.requestorComparator = requestorComparator;
        this.requestComparator = requestComparator;
    }
}

