/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.gobblin.util.request_allocation.AllocatedRequestsIterator;
import org.apache.gobblin.util.request_allocation.HierarchicalPrioritizer;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.RequestAllocatorUtils;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalAllocator<T extends Request<T>>
implements RequestAllocator<T> {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalAllocator.class);
    private final HierarchicalPrioritizer<T> prioritizer;
    private final RequestAllocator<T> underlying;

    @Override
    public AllocatedRequestsIterator<T> allocateRequests(Iterator<? extends Requestor<T>> requestors, ResourcePool resourcePool) {
        ArrayList requestorList = Lists.newArrayList(requestors);
        Comparator requestorComparator = new Comparator<Requestor<T>>(){

            @Override
            public int compare(Requestor<T> o1, Requestor<T> o2) {
                return HierarchicalAllocator.this.prioritizer.compareRequestors(o1, o2);
            }
        };
        Collections.sort(requestorList, requestorComparator);
        return new HierarchicalIterator(resourcePool, new SingleTierIterator(requestorComparator, requestorList));
    }

    public HierarchicalAllocator(HierarchicalPrioritizer<T> prioritizer, RequestAllocator<T> underlying) {
        this.prioritizer = prioritizer;
        this.underlying = underlying;
    }

    private class SingleTierIterator
    implements Iterator<Requestor<T>> {
        private final Comparator<Requestor<T>> prioritizer;
        private final List<Requestor<T>> requestors;
        private final Requestor<T> referenceRequestor;
        private int nextRequestorIdx;

        public SingleTierIterator(Comparator<Requestor<T>> prioritizer, List<Requestor<T>> requestors) {
            this(prioritizer, requestors, 0);
        }

        private SingleTierIterator(Comparator<Requestor<T>> prioritizer, List<Requestor<T>> requestors, int initialIndex) {
            this.prioritizer = prioritizer;
            this.requestors = requestors;
            this.referenceRequestor = this.requestors.size() > initialIndex ? requestors.get(initialIndex) : null;
            this.nextRequestorIdx = initialIndex;
            log.debug("Starting a single tier iterator with reference requestor: {}", this.referenceRequestor);
        }

        @Override
        public boolean hasNext() {
            return this.requestors.size() > this.nextRequestorIdx && this.prioritizer.compare(this.referenceRequestor, this.requestors.get(this.nextRequestorIdx)) == 0;
        }

        @Override
        public Requestor<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.requestors.get(this.nextRequestorIdx++);
        }

        Optional<SingleTierIterator> nextTier() {
            if (this.nextRequestorIdx < this.requestors.size()) {
                return Optional.of((Object)new SingleTierIterator(this.prioritizer, this.requestors, this.nextRequestorIdx));
            }
            return Optional.absent();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class HierarchicalIterator
    implements AllocatedRequestsIterator<T> {
        private SingleTierIterator singleTierIterator;
        private AllocatedRequestsIterator<T> currentIterator;
        private ResourcePool resourcePool;
        private final ResourceRequirement currentRequirement;

        public HierarchicalIterator(ResourcePool resourcePool, SingleTierIterator singleTierIterator) {
            this.singleTierIterator = singleTierIterator;
            this.resourcePool = resourcePool;
            this.currentRequirement = resourcePool.getResourceRequirementBuilder().zero().build();
        }

        @Override
        public boolean hasNext() {
            while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.currentIterator != null) {
                    this.currentRequirement.add(this.currentIterator.totalResourcesUsed());
                }
                if (this.resourcePool.exceedsSoftBound(this.currentRequirement, true)) {
                    return false;
                }
                Optional<SingleTierIterator> tmp = this.singleTierIterator.nextTier();
                if (!tmp.isPresent()) {
                    return false;
                }
                this.singleTierIterator = (SingleTierIterator)tmp.get();
                ResourcePool contractedPool = this.resourcePool.contractPool(this.currentRequirement);
                this.currentIterator = HierarchicalAllocator.this.underlying.allocateRequests(this.singleTierIterator, contractedPool);
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Request)this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceRequirement totalResourcesUsed() {
            return ResourceRequirement.add(this.currentRequirement, this.currentIterator.totalResourcesUsed(), null);
        }
    }

    public static class Factory
    implements RequestAllocator.Factory {
        @Override
        public <T extends Request<T>> RequestAllocator<T> createRequestAllocator(RequestAllocatorConfig<T> cofiguration) {
            Preconditions.checkArgument((boolean)(cofiguration.getPrioritizer() instanceof HierarchicalPrioritizer), (Object)("Prioritizer must be a " + HierarchicalPrioritizer.class.getSimpleName()));
            RequestAllocator<T> underlying = RequestAllocatorUtils.inferFromConfig(cofiguration);
            return new HierarchicalAllocator<T>((HierarchicalPrioritizer)cofiguration.getPrioritizer(), underlying);
        }
    }
}

