/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.reflection;

import java.lang.reflect.Field;
import java.util.Arrays;

public class RestrictedFieldAccessingUtils {
    private RestrictedFieldAccessingUtils() {
    }

    public static Object getRestrictedFieldByReflection(Object containingObj, String fieldName, Class clazz) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(containingObj);
    }

    public static Object getRestrictedFieldByReflectionRecursively(Object containingObj, String fieldName, Class clazz) throws NoSuchFieldException, IllegalAccessException {
        if (clazz.getCanonicalName().equals("java.lang.Object")) {
            throw new NoSuchFieldException(String.format("Field %s doesn't exist in specified class and its ancestors", fieldName));
        }
        if (!Arrays.asList(clazz.getDeclaredFields()).stream().anyMatch(x -> x.getName().equals(fieldName))) {
            return RestrictedFieldAccessingUtils.getRestrictedFieldByReflectionRecursively(containingObj, fieldName, clazz.getSuperclass());
        }
        return RestrictedFieldAccessingUtils.getRestrictedFieldByReflection(containingObj, fieldName, clazz);
    }
}

