/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.measurement;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.LongStream;

public class GrowthMilestoneTracker {
    private final Iterator<Long> milestoneSequence = this.createMilestoneSequence();
    private Long nextMilestone = this.milestoneSequence.next();

    public final boolean isAnotherMilestone(long n) {
        return this.calcLargestNewMilestone(n).isPresent();
    }

    public final Optional<Long> calcLargestNewMilestone(long n) {
        Long largestMilestoneAchieved;
        if (n < this.nextMilestone) {
            return Optional.empty();
        }
        do {
            largestMilestoneAchieved = this.nextMilestone;
            Long l = this.nextMilestone = this.milestoneSequence.hasNext() ? this.milestoneSequence.next() : Long.valueOf(Long.MAX_VALUE);
        } while (n >= this.nextMilestone);
        return Optional.of(largestMilestoneAchieved);
    }

    protected Iterator<Long> createMilestoneSequence() {
        LongStream initially = LongStream.iterate(1L, i -> i * 10L).limit((long)Math.log10(1000.0));
        LongStream next = LongStream.rangeClosed(2L, 9L).map(i -> i * 5000L);
        LongStream then = LongStream.rangeClosed(2L, 9L).map(i -> i * 25000L);
        LongStream thereafter = LongStream.iterate(250000L, i -> i + 50000L);
        return LongStream.concat(initially, LongStream.concat(next, LongStream.concat(then, thereafter))).iterator();
    }
}

