/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.logs;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4jConfigurationHelper {
    private static final Logger LOG = Logger.getLogger(Log4jConfigurationHelper.class);
    public static final String LOG_LEVEL_OVERRIDE_MAP = "log.levelOverride.map";

    public static void updateLog4jConfiguration(Class<?> targetClass, String log4jPath, String log4jFileName) throws IOException {
        try (Closer closer = Closer.create();){
            InputStream fileInputStream = (InputStream)closer.register((Closeable)new FileInputStream(log4jPath));
            InputStream inputStream = (InputStream)closer.register((Closeable)targetClass.getResourceAsStream("/" + log4jFileName));
            Properties customProperties = new Properties();
            customProperties.load(fileInputStream);
            Properties originalProperties = new Properties();
            originalProperties.load(inputStream);
            for (Map.Entry<Object, Object> entry : customProperties.entrySet()) {
                originalProperties.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((Properties)originalProperties);
        }
    }

    public static void setLogLevel(Collection<String> logClassesAndLevelString) {
        for (String logClassAndLevelString : logClassesAndLevelString) {
            String[] logClassAndLevel = logClassAndLevelString.split("=");
            if (logClassAndLevel.length != 2) {
                LOG.warn((Object)"Invalid value for config log.levelOverride.map");
            }
            Logger.getLogger((String)logClassAndLevel[0]).setLevel(Level.toLevel((String)logClassAndLevel[1]));
        }
    }
}

