/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.limiter.BaseLimiterType;
import org.apache.gobblin.util.limiter.CountBasedLimiter;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.PoolBasedLimiter;
import org.apache.gobblin.util.limiter.RateBasedLimiter;
import org.apache.gobblin.util.limiter.TimeBasedLimiter;

public class DefaultLimiterFactory {
    public static final String EXTRACT_LIMIT_TYPE_KEY = "extract.limit.type";
    public static final String EXTRACT_LIMIT_RATE_LIMIT_KEY = "extract.limit.rateLimit";
    public static final String EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY = "extract.limit.rateLimitTimeunit";
    public static final String EXTRACT_LIMIT_TIME_LIMIT_KEY = "extract.limit.timeLimit";
    public static final String EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY = "extract.limit.timeLimitTimeunit";
    public static final String EXTRACT_LIMIT_COUNT_LIMIT_KEY = "extract.limit.count.limit";
    public static final String EXTRACT_LIMIT_POOL_SIZE_KEY = "extract.limit.pool.size";
    @Deprecated
    public static final String EXTRACT_LIMIT_RATE_LIMIT_KEY_DEP = "extract.limit.rate.limit";
    @Deprecated
    public static final String EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY_DEP = "extract.limit.rate.limit.timeunit";
    @Deprecated
    public static final String EXTRACT_LIMIT_TIME_LIMIT_KEY_DEP = "extract.limit.time.limit";
    @Deprecated
    public static final String EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY_DEP = "extract.limit.time.limit.timeunit";

    public static Limiter newLimiter(State state) {
        state = DefaultLimiterFactory.convertDeprecatedConfigs(state);
        Preconditions.checkArgument((boolean)state.contains(EXTRACT_LIMIT_TYPE_KEY), (Object)String.format("Missing configuration property %s for the Limiter type", EXTRACT_LIMIT_TYPE_KEY));
        BaseLimiterType type = BaseLimiterType.forName(state.getProp(EXTRACT_LIMIT_TYPE_KEY));
        switch (type) {
            case RATE_BASED: {
                Preconditions.checkArgument((boolean)state.contains(EXTRACT_LIMIT_RATE_LIMIT_KEY));
                int rateLimit = Integer.parseInt(state.getProp(EXTRACT_LIMIT_RATE_LIMIT_KEY));
                if (state.contains(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY)) {
                    TimeUnit rateTimeUnit = TimeUnit.valueOf(state.getProp(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY).toUpperCase());
                    return new RateBasedLimiter(rateLimit, rateTimeUnit);
                }
                return new RateBasedLimiter(rateLimit);
            }
            case TIME_BASED: {
                Preconditions.checkArgument((boolean)state.contains(EXTRACT_LIMIT_TIME_LIMIT_KEY));
                long timeLimit = Long.parseLong(state.getProp(EXTRACT_LIMIT_TIME_LIMIT_KEY));
                if (state.contains(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY)) {
                    TimeUnit timeTimeUnit = TimeUnit.valueOf(state.getProp(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY).toUpperCase());
                    return new TimeBasedLimiter(timeLimit, timeTimeUnit);
                }
                return new TimeBasedLimiter(timeLimit);
            }
            case COUNT_BASED: {
                Preconditions.checkArgument((boolean)state.contains(EXTRACT_LIMIT_COUNT_LIMIT_KEY));
                long countLimit = Long.parseLong(state.getProp(EXTRACT_LIMIT_COUNT_LIMIT_KEY));
                return new CountBasedLimiter(countLimit);
            }
            case POOL_BASED: {
                Preconditions.checkArgument((boolean)state.contains(EXTRACT_LIMIT_POOL_SIZE_KEY));
                int poolSize = Integer.parseInt(state.getProp(EXTRACT_LIMIT_POOL_SIZE_KEY));
                return new PoolBasedLimiter(poolSize);
            }
        }
        throw new IllegalArgumentException("Unrecognized Limiter type: " + type.toString());
    }

    private static State convertDeprecatedConfigs(State state) {
        if (state.contains(EXTRACT_LIMIT_RATE_LIMIT_KEY_DEP)) {
            state.setProp(EXTRACT_LIMIT_RATE_LIMIT_KEY, (Object)state.getProp(EXTRACT_LIMIT_RATE_LIMIT_KEY_DEP));
            state.removeProp(EXTRACT_LIMIT_RATE_LIMIT_KEY_DEP);
        }
        if (state.contains(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY_DEP)) {
            state.setProp(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY, (Object)state.getProp(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY_DEP));
            state.removeProp(EXTRACT_LIMIT_RATE_LIMIT_TIMEUNIT_KEY_DEP);
        }
        if (state.contains(EXTRACT_LIMIT_TIME_LIMIT_KEY_DEP)) {
            state.setProp(EXTRACT_LIMIT_TIME_LIMIT_KEY, (Object)state.getProp(EXTRACT_LIMIT_TIME_LIMIT_KEY_DEP));
            state.removeProp(EXTRACT_LIMIT_TIME_LIMIT_KEY_DEP);
        }
        if (state.contains(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY_DEP)) {
            state.setProp(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY, (Object)state.getProp(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY_DEP));
            state.removeProp(EXTRACT_LIMIT_TIME_LIMIT_TIMEUNIT_KEY_DEP);
        }
        return state;
    }
}

