/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.zaxxer.hikari.HikariDataSource;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.gobblin.password.PasswordManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProvider
implements Provider<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceProvider.class);
    private static final AtomicInteger POOL_NUM = new AtomicInteger(0);
    public static final String GOBBLIN_UTIL_JDBC_PREFIX = "gobblin.util.jdbc.";
    public static final String CONN_DRIVER = "gobblin.util.jdbc.conn.driver";
    public static final String CONN_URL = "gobblin.util.jdbc.conn.url";
    public static final String USERNAME = "gobblin.util.jdbc.username";
    public static final String PASSWORD = "gobblin.util.jdbc.password";
    public static final String SKIP_VALIDATION_QUERY = "gobblin.util.jdbc.skip.validation.query";
    public static final String MAX_ACTIVE_CONNS = "gobblin.util.jdbc.max.active.connections";
    public static final String DEFAULT_CONN_DRIVER = "com.mysql.cj.jdbc.Driver";
    protected final HikariDataSource dataSource;

    @Inject
    public DataSourceProvider(@Named(value="dataSourceProperties") Properties properties) {
        this.dataSource = new HikariDataSource();
        this.dataSource.setPoolName("HikariPool-" + POOL_NUM.incrementAndGet() + "-" + this.getClass().getSimpleName());
        this.dataSource.setDriverClassName(properties.getProperty(CONN_DRIVER, DEFAULT_CONN_DRIVER));
        if (!Boolean.parseBoolean(properties.getProperty(SKIP_VALIDATION_QUERY, "false"))) {
            String validationQuery = "select case when @@read_only = 0 then 1 else (select table_name from information_schema.tables) end as `1`";
            LOG.info("setting `DataSource` validation query: 'select case when @@read_only = 0 then 1 else (select table_name from information_schema.tables) end as `1`'");
            this.dataSource.setConnectionTestQuery("select case when @@read_only = 0 then 1 else (select table_name from information_schema.tables) end as `1`");
            this.dataSource.setIdleTimeout(Duration.ofSeconds(60L).toMillis());
        }
        this.dataSource.setJdbcUrl(properties.getProperty(CONN_URL));
        this.dataSource.setMinimumIdle(0);
        if (properties.containsKey(USERNAME) && properties.containsKey(PASSWORD)) {
            this.dataSource.setUsername(properties.getProperty(USERNAME));
            this.dataSource.setPassword(PasswordManager.getInstance((Properties)properties).readPassword(properties.getProperty(PASSWORD)));
        }
        if (properties.containsKey(MAX_ACTIVE_CONNS)) {
            this.dataSource.setMaximumPoolSize(Integer.parseInt(properties.getProperty(MAX_ACTIVE_CONNS)));
        }
    }

    public DataSourceProvider() {
        LOG.warn("Creating {} without setting validation query.\n Stacktrace of current thread {}", (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(Thread.currentThread().getStackTrace()).replace(", ", "\n  at "));
        this.dataSource = new HikariDataSource();
    }

    public DataSource get() {
        return this.dataSource;
    }
}

