/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.jdbc;

import com.google.common.base.Preconditions;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.jdbc.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceBuilder.class);
    private String url;
    private String driver;
    private String userName;
    private String passWord;
    private Integer maxActiveConnections;
    private String cryptoKeyLocation;
    private Boolean useStrongEncryption;
    private State state;

    public static DataSourceBuilder builder() {
        return new DataSourceBuilder();
    }

    public DataSourceBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DataSourceBuilder driver(String driver) {
        this.driver = driver;
        return this;
    }

    public DataSourceBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public DataSourceBuilder passWord(String passWord) {
        this.passWord = passWord;
        return this;
    }

    public DataSourceBuilder maxActiveConnections(int maxActiveConnections) {
        this.maxActiveConnections = maxActiveConnections;
        return this;
    }

    public DataSourceBuilder cryptoKeyLocation(String cryptoKeyLocation) {
        this.cryptoKeyLocation = cryptoKeyLocation;
        return this;
    }

    public DataSourceBuilder useStrongEncryption(boolean useStrongEncryption) {
        this.useStrongEncryption = useStrongEncryption;
        return this;
    }

    public DataSourceBuilder state(State state) {
        this.state = state;
        return this;
    }

    public DataSource build() {
        this.validate();
        Properties properties = new Properties();
        if (this.state != null) {
            properties = this.state.getProperties();
        }
        properties.setProperty("gobblin.util.jdbc.conn.url", this.url);
        properties.setProperty("gobblin.util.jdbc.username", this.userName);
        properties.setProperty("gobblin.util.jdbc.password", this.passWord);
        properties.setProperty("gobblin.util.jdbc.conn.driver", this.driver);
        if (!StringUtils.isEmpty((String)this.cryptoKeyLocation)) {
            properties.setProperty("encrypt.key.loc", this.cryptoKeyLocation);
        }
        if (this.maxActiveConnections != null) {
            properties.setProperty("gobblin.util.jdbc.max.active.connections", this.maxActiveConnections.toString());
        }
        if (this.useStrongEncryption != null) {
            properties.setProperty("encrypt.use.strong.encryptor", this.useStrongEncryption.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building DataSource with properties " + properties);
        }
        return new DataSourceProvider(properties).get();
    }

    private void validate() {
        DataSourceBuilder.validateNotEmpty(this.url, "url");
        DataSourceBuilder.validateNotEmpty(this.driver, "driver");
        DataSourceBuilder.validateNotEmpty(this.passWord, "passWord");
        Preconditions.checkArgument((this.maxActiveConnections == null || this.maxActiveConnections > 0 ? 1 : 0) != 0, (Object)"maxActiveConnections should be a positive integer.");
    }

    private static void validateNotEmpty(String s, String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)s) ? 1 : 0) != 0, (Object)(name + " should not be empty."));
    }

    public String toString() {
        return "DataSourceBuilder(url=" + this.url + ", driver=" + this.driver + ", userName=" + this.userName + ", maxActiveConnections=" + this.maxActiveConnections + ", cryptoKeyLocation=" + this.cryptoKeyLocation + ", useStrongEncryption=" + this.useStrongEncryption + ", state=" + this.state + ")";
    }
}

